/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.S3Object;
import com.amazonaws.services.robomaker.model.transform.DeploymentConfigMarshaller;
import java.io.Serializable;

public class DeploymentConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer concurrentDeploymentPercentage;
    private Integer failureThresholdPercentage;
    private Long robotDeploymentTimeoutInSeconds;
    private S3Object downloadConditionFile;

    public void setConcurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
        this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
    }

    public Integer getConcurrentDeploymentPercentage() {
        return this.concurrentDeploymentPercentage;
    }

    public DeploymentConfig withConcurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
        this.setConcurrentDeploymentPercentage(concurrentDeploymentPercentage);
        return this;
    }

    public void setFailureThresholdPercentage(Integer failureThresholdPercentage) {
        this.failureThresholdPercentage = failureThresholdPercentage;
    }

    public Integer getFailureThresholdPercentage() {
        return this.failureThresholdPercentage;
    }

    public DeploymentConfig withFailureThresholdPercentage(Integer failureThresholdPercentage) {
        this.setFailureThresholdPercentage(failureThresholdPercentage);
        return this;
    }

    public void setRobotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
        this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
    }

    public Long getRobotDeploymentTimeoutInSeconds() {
        return this.robotDeploymentTimeoutInSeconds;
    }

    public DeploymentConfig withRobotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
        this.setRobotDeploymentTimeoutInSeconds(robotDeploymentTimeoutInSeconds);
        return this;
    }

    public void setDownloadConditionFile(S3Object downloadConditionFile) {
        this.downloadConditionFile = downloadConditionFile;
    }

    public S3Object getDownloadConditionFile() {
        return this.downloadConditionFile;
    }

    public DeploymentConfig withDownloadConditionFile(S3Object downloadConditionFile) {
        this.setDownloadConditionFile(downloadConditionFile);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConcurrentDeploymentPercentage() != null) {
            sb.append("ConcurrentDeploymentPercentage: ").append(this.getConcurrentDeploymentPercentage()).append(",");
        }
        if (this.getFailureThresholdPercentage() != null) {
            sb.append("FailureThresholdPercentage: ").append(this.getFailureThresholdPercentage()).append(",");
        }
        if (this.getRobotDeploymentTimeoutInSeconds() != null) {
            sb.append("RobotDeploymentTimeoutInSeconds: ").append(this.getRobotDeploymentTimeoutInSeconds()).append(",");
        }
        if (this.getDownloadConditionFile() != null) {
            sb.append("DownloadConditionFile: ").append(this.getDownloadConditionFile());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig)obj;
        if (other.getConcurrentDeploymentPercentage() == null ^ this.getConcurrentDeploymentPercentage() == null) {
            return false;
        }
        if (other.getConcurrentDeploymentPercentage() != null && !other.getConcurrentDeploymentPercentage().equals(this.getConcurrentDeploymentPercentage())) {
            return false;
        }
        if (other.getFailureThresholdPercentage() == null ^ this.getFailureThresholdPercentage() == null) {
            return false;
        }
        if (other.getFailureThresholdPercentage() != null && !other.getFailureThresholdPercentage().equals(this.getFailureThresholdPercentage())) {
            return false;
        }
        if (other.getRobotDeploymentTimeoutInSeconds() == null ^ this.getRobotDeploymentTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getRobotDeploymentTimeoutInSeconds() != null && !other.getRobotDeploymentTimeoutInSeconds().equals(this.getRobotDeploymentTimeoutInSeconds())) {
            return false;
        }
        if (other.getDownloadConditionFile() == null ^ this.getDownloadConditionFile() == null) {
            return false;
        }
        return other.getDownloadConditionFile() == null || other.getDownloadConditionFile().equals(this.getDownloadConditionFile());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConcurrentDeploymentPercentage() == null ? 0 : this.getConcurrentDeploymentPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getFailureThresholdPercentage() == null ? 0 : this.getFailureThresholdPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getRobotDeploymentTimeoutInSeconds() == null ? 0 : this.getRobotDeploymentTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getDownloadConditionFile() == null ? 0 : this.getDownloadConditionFile().hashCode());
        return hashCode;
    }

    public DeploymentConfig clone() {
        try {
            return (DeploymentConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

