/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.S3KeyOutput;
import com.amazonaws.services.robomaker.model.transform.DataSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String s3Bucket;
    private List<S3KeyOutput> s3Keys;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataSource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public DataSource withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public List<S3KeyOutput> getS3Keys() {
        return this.s3Keys;
    }

    public void setS3Keys(Collection<S3KeyOutput> s3Keys) {
        if (s3Keys == null) {
            this.s3Keys = null;
            return;
        }
        this.s3Keys = new ArrayList<S3KeyOutput>(s3Keys);
    }

    public DataSource withS3Keys(S3KeyOutput ... s3Keys) {
        if (this.s3Keys == null) {
            this.setS3Keys(new ArrayList<S3KeyOutput>(s3Keys.length));
        }
        for (S3KeyOutput ele : s3Keys) {
            this.s3Keys.add(ele);
        }
        return this;
    }

    public DataSource withS3Keys(Collection<S3KeyOutput> s3Keys) {
        this.setS3Keys(s3Keys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3Keys() != null) {
            sb.append("S3Keys: ").append(this.getS3Keys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3Keys() == null ^ this.getS3Keys() == null) {
            return false;
        }
        return other.getS3Keys() == null || other.getS3Keys().equals(this.getS3Keys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3Keys() == null ? 0 : this.getS3Keys().hashCode());
        return hashCode;
    }

    public DataSource clone() {
        try {
            return (DataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

