/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.robomaker.model.DeploymentApplicationConfig;
import com.amazonaws.services.robomaker.model.DeploymentConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateDeploymentJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DeploymentConfig deploymentConfig;
    private String clientRequestToken;
    private String fleet;
    private List<DeploymentApplicationConfig> deploymentApplicationConfigs;
    private Map<String, String> tags;

    public void setDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.deploymentConfig = deploymentConfig;
    }

    public DeploymentConfig getDeploymentConfig() {
        return this.deploymentConfig;
    }

    public CreateDeploymentJobRequest withDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.setDeploymentConfig(deploymentConfig);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateDeploymentJobRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setFleet(String fleet) {
        this.fleet = fleet;
    }

    public String getFleet() {
        return this.fleet;
    }

    public CreateDeploymentJobRequest withFleet(String fleet) {
        this.setFleet(fleet);
        return this;
    }

    public List<DeploymentApplicationConfig> getDeploymentApplicationConfigs() {
        return this.deploymentApplicationConfigs;
    }

    public void setDeploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
        if (deploymentApplicationConfigs == null) {
            this.deploymentApplicationConfigs = null;
            return;
        }
        this.deploymentApplicationConfigs = new ArrayList<DeploymentApplicationConfig>(deploymentApplicationConfigs);
    }

    public CreateDeploymentJobRequest withDeploymentApplicationConfigs(DeploymentApplicationConfig ... deploymentApplicationConfigs) {
        if (this.deploymentApplicationConfigs == null) {
            this.setDeploymentApplicationConfigs(new ArrayList<DeploymentApplicationConfig>(deploymentApplicationConfigs.length));
        }
        for (DeploymentApplicationConfig ele : deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs.add(ele);
        }
        return this;
    }

    public CreateDeploymentJobRequest withDeploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
        this.setDeploymentApplicationConfigs(deploymentApplicationConfigs);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateDeploymentJobRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateDeploymentJobRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateDeploymentJobRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentConfig() != null) {
            sb.append("DeploymentConfig: ").append(this.getDeploymentConfig()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getFleet() != null) {
            sb.append("Fleet: ").append(this.getFleet()).append(",");
        }
        if (this.getDeploymentApplicationConfigs() != null) {
            sb.append("DeploymentApplicationConfigs: ").append(this.getDeploymentApplicationConfigs()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentJobRequest)) {
            return false;
        }
        CreateDeploymentJobRequest other = (CreateDeploymentJobRequest)obj;
        if (other.getDeploymentConfig() == null ^ this.getDeploymentConfig() == null) {
            return false;
        }
        if (other.getDeploymentConfig() != null && !other.getDeploymentConfig().equals(this.getDeploymentConfig())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getFleet() == null ^ this.getFleet() == null) {
            return false;
        }
        if (other.getFleet() != null && !other.getFleet().equals(this.getFleet())) {
            return false;
        }
        if (other.getDeploymentApplicationConfigs() == null ^ this.getDeploymentApplicationConfigs() == null) {
            return false;
        }
        if (other.getDeploymentApplicationConfigs() != null && !other.getDeploymentApplicationConfigs().equals(this.getDeploymentApplicationConfigs())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentConfig() == null ? 0 : this.getDeploymentConfig().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getFleet() == null ? 0 : this.getFleet().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentApplicationConfigs() == null ? 0 : this.getDeploymentApplicationConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateDeploymentJobRequest clone() {
        return (CreateDeploymentJobRequest)super.clone();
    }
}

