/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldbsession.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qldbsession.model.ValueHolder;
import com.amazonaws.services.qldbsession.model.transform.PageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Page
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ValueHolder> values;
    private String nextPageToken;

    public List<ValueHolder> getValues() {
        return this.values;
    }

    public void setValues(Collection<ValueHolder> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<ValueHolder>(values);
    }

    public Page withValues(ValueHolder ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<ValueHolder>(values.length));
        }
        for (ValueHolder ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public Page withValues(Collection<ValueHolder> values) {
        this.setValues(values);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public Page withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public Page clone() {
        try {
            return (Page)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

