/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qldb.model.S3ExportConfiguration;

@SdkInternalApi
public class S3ExportConfigurationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").build();
    private static final S3ExportConfigurationMarshaller instance = new S3ExportConfigurationMarshaller();

    public static S3ExportConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ExportConfiguration s3ExportConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3ExportConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ExportConfiguration.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall(s3ExportConfiguration.getPrefix(), PREFIX_BINDING);
            protocolMarshaller.marshall(s3ExportConfiguration.getEncryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

