/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeruntime;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.personalizeruntime.AmazonPersonalizeRuntimeAsync;
import com.amazonaws.services.personalizeruntime.AmazonPersonalizeRuntimeAsyncClientBuilder;
import com.amazonaws.services.personalizeruntime.AmazonPersonalizeRuntimeClient;
import com.amazonaws.services.personalizeruntime.model.GetPersonalizedRankingRequest;
import com.amazonaws.services.personalizeruntime.model.GetPersonalizedRankingResult;
import com.amazonaws.services.personalizeruntime.model.GetRecommendationsRequest;
import com.amazonaws.services.personalizeruntime.model.GetRecommendationsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPersonalizeRuntimeAsyncClient
extends AmazonPersonalizeRuntimeClient
implements AmazonPersonalizeRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPersonalizeRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonPersonalizeRuntimeAsyncClientBuilder.standard();
    }

    AmazonPersonalizeRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetPersonalizedRankingResult> getPersonalizedRankingAsync(GetPersonalizedRankingRequest request) {
        return this.getPersonalizedRankingAsync(request, null);
    }

    @Override
    public Future<GetPersonalizedRankingResult> getPersonalizedRankingAsync(GetPersonalizedRankingRequest request, final AsyncHandler<GetPersonalizedRankingRequest, GetPersonalizedRankingResult> asyncHandler) {
        final GetPersonalizedRankingRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPersonalizedRankingResult>(){

            @Override
            public GetPersonalizedRankingResult call() throws Exception {
                GetPersonalizedRankingResult result = null;
                try {
                    result = AmazonPersonalizeRuntimeAsyncClient.this.executeGetPersonalizedRanking(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecommendationsResult> getRecommendationsAsync(GetRecommendationsRequest request) {
        return this.getRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetRecommendationsResult> getRecommendationsAsync(GetRecommendationsRequest request, final AsyncHandler<GetRecommendationsRequest, GetRecommendationsResult> asyncHandler) {
        final GetRecommendationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecommendationsResult>(){

            @Override
            public GetRecommendationsResult call() throws Exception {
                GetRecommendationsResult result = null;
                try {
                    result = AmazonPersonalizeRuntimeAsyncClient.this.executeGetRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

