/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeevents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.personalizeevents.model.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trackingId;
    private String userId;
    private String sessionId;
    private List<Event> eventList;

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public PutEventsRequest withTrackingId(String trackingId) {
        this.setTrackingId(trackingId);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PutEventsRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public PutEventsRequest withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public List<Event> getEventList() {
        return this.eventList;
    }

    public void setEventList(Collection<Event> eventList) {
        if (eventList == null) {
            this.eventList = null;
            return;
        }
        this.eventList = new ArrayList<Event>(eventList);
    }

    public PutEventsRequest withEventList(Event ... eventList) {
        if (this.eventList == null) {
            this.setEventList(new ArrayList<Event>(eventList.length));
        }
        for (Event ele : eventList) {
            this.eventList.add(ele);
        }
        return this;
    }

    public PutEventsRequest withEventList(Collection<Event> eventList) {
        this.setEventList(eventList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrackingId() != null) {
            sb.append("TrackingId: ").append(this.getTrackingId()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getEventList() != null) {
            sb.append("EventList: ").append(this.getEventList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequest)) {
            return false;
        }
        PutEventsRequest other = (PutEventsRequest)obj;
        if (other.getTrackingId() == null ^ this.getTrackingId() == null) {
            return false;
        }
        if (other.getTrackingId() != null && !other.getTrackingId().equals(this.getTrackingId())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getEventList() == null ^ this.getEventList() == null) {
            return false;
        }
        return other.getEventList() == null || other.getEventList().equals(this.getEventList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrackingId() == null ? 0 : this.getTrackingId().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getEventList() == null ? 0 : this.getEventList().hashCode());
        return hashCode;
    }

    @Override
    public PutEventsRequest clone() {
        return (PutEventsRequest)super.clone();
    }
}

