/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeevents;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.personalizeevents.AmazonPersonalizeEventsAsync;
import com.amazonaws.services.personalizeevents.AmazonPersonalizeEventsAsyncClientBuilder;
import com.amazonaws.services.personalizeevents.AmazonPersonalizeEventsClient;
import com.amazonaws.services.personalizeevents.model.PutEventsRequest;
import com.amazonaws.services.personalizeevents.model.PutEventsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPersonalizeEventsAsyncClient
extends AmazonPersonalizeEventsClient
implements AmazonPersonalizeEventsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPersonalizeEventsAsyncClientBuilder asyncBuilder() {
        return AmazonPersonalizeEventsAsyncClientBuilder.standard();
    }

    AmazonPersonalizeEventsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request) {
        return this.putEventsAsync(request, null);
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request, final AsyncHandler<PutEventsRequest, PutEventsResult> asyncHandler) {
        final PutEventsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEventsResult>(){

            @Override
            public PutEventsResult call() throws Exception {
                PutEventsResult result = null;
                try {
                    result = AmazonPersonalizeEventsAsyncClient.this.executePutEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

