/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.personalize.model.RecipeSummary;
import java.util.Date;

@SdkInternalApi
public class RecipeSummaryMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> RECIPEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recipeArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDateTime").timestampFormat("unixTimestamp").build();
    private static final RecipeSummaryMarshaller instance = new RecipeSummaryMarshaller();

    public static RecipeSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecipeSummary recipeSummary, ProtocolMarshaller protocolMarshaller) {
        if (recipeSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recipeSummary.getName(), NAME_BINDING);
            protocolMarshaller.marshall(recipeSummary.getRecipeArn(), RECIPEARN_BINDING);
            protocolMarshaller.marshall(recipeSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(recipeSummary.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall(recipeSummary.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

