/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.personalize.model.Recipe;
import java.util.Date;

@SdkInternalApi
public class RecipeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> RECIPEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recipeArn").build();
    private static final MarshallingInfo<String> ALGORITHMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmArn").build();
    private static final MarshallingInfo<String> FEATURETRANSFORMATIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("featureTransformationArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RECIPETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recipeType").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDateTime").timestampFormat("unixTimestamp").build();
    private static final RecipeMarshaller instance = new RecipeMarshaller();

    public static RecipeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Recipe recipe, ProtocolMarshaller protocolMarshaller) {
        if (recipe == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recipe.getName(), NAME_BINDING);
            protocolMarshaller.marshall(recipe.getRecipeArn(), RECIPEARN_BINDING);
            protocolMarshaller.marshall(recipe.getAlgorithmArn(), ALGORITHMARN_BINDING);
            protocolMarshaller.marshall(recipe.getFeatureTransformationArn(), FEATURETRANSFORMATIONARN_BINDING);
            protocolMarshaller.marshall(recipe.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(recipe.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(recipe.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall(recipe.getRecipeType(), RECIPETYPE_BINDING);
            protocolMarshaller.marshall(recipe.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

