/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.HPOConfig;

@SdkInternalApi
public class HPOConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> HPOOBJECTIVE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hpoObjective").build();
    private static final MarshallingInfo<StructuredPojo> HPORESOURCECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hpoResourceConfig").build();
    private static final MarshallingInfo<StructuredPojo> ALGORITHMHYPERPARAMETERRANGES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmHyperParameterRanges").build();
    private static final HPOConfigMarshaller instance = new HPOConfigMarshaller();

    public static HPOConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(HPOConfig hPOConfig, ProtocolMarshaller protocolMarshaller) {
        if (hPOConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hPOConfig.getHpoObjective(), HPOOBJECTIVE_BINDING);
            protocolMarshaller.marshall(hPOConfig.getHpoResourceConfig(), HPORESOURCECONFIG_BINDING);
            protocolMarshaller.marshall(hPOConfig.getAlgorithmHyperParameterRanges(), ALGORITHMHYPERPARAMETERRANGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

