/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.Algorithm;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class AlgorithmMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ALGORITHMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmArn").build();
    private static final MarshallingInfo<StructuredPojo> ALGORITHMIMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmImage").build();
    private static final MarshallingInfo<Map> DEFAULTHYPERPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultHyperParameters").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTHYPERPARAMETERRANGES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultHyperParameterRanges").build();
    private static final MarshallingInfo<Map> DEFAULTRESOURCECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultResourceConfig").build();
    private static final MarshallingInfo<String> TRAININGINPUTMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trainingInputMode").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDateTime").timestampFormat("unixTimestamp").build();
    private static final AlgorithmMarshaller instance = new AlgorithmMarshaller();

    public static AlgorithmMarshaller getInstance() {
        return instance;
    }

    public void marshall(Algorithm algorithm, ProtocolMarshaller protocolMarshaller) {
        if (algorithm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(algorithm.getName(), NAME_BINDING);
            protocolMarshaller.marshall(algorithm.getAlgorithmArn(), ALGORITHMARN_BINDING);
            protocolMarshaller.marshall(algorithm.getAlgorithmImage(), ALGORITHMIMAGE_BINDING);
            protocolMarshaller.marshall(algorithm.getDefaultHyperParameters(), DEFAULTHYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall(algorithm.getDefaultHyperParameterRanges(), DEFAULTHYPERPARAMETERRANGES_BINDING);
            protocolMarshaller.marshall(algorithm.getDefaultResourceConfig(), DEFAULTRESOURCECONFIG_BINDING);
            protocolMarshaller.marshall(algorithm.getTrainingInputMode(), TRAININGINPUTMODE_BINDING);
            protocolMarshaller.marshall(algorithm.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(algorithm.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall(algorithm.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

