/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.transform.S3DataConfigMarshaller;
import java.io.Serializable;

public class S3DataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private String kmsKeyArn;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public S3DataConfig withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public S3DataConfig withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataConfig)) {
            return false;
        }
        S3DataConfig other = (S3DataConfig)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        return other.getKmsKeyArn() == null || other.getKmsKeyArn().equals(this.getKmsKeyArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        return hashCode;
    }

    public S3DataConfig clone() {
        try {
            return (S3DataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

