/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.HPOObjective;
import com.amazonaws.services.personalize.model.HPOResourceConfig;
import com.amazonaws.services.personalize.model.HyperParameterRanges;
import com.amazonaws.services.personalize.model.transform.HPOConfigMarshaller;
import java.io.Serializable;

public class HPOConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private HPOObjective hpoObjective;
    private HPOResourceConfig hpoResourceConfig;
    private HyperParameterRanges algorithmHyperParameterRanges;

    public void setHpoObjective(HPOObjective hpoObjective) {
        this.hpoObjective = hpoObjective;
    }

    public HPOObjective getHpoObjective() {
        return this.hpoObjective;
    }

    public HPOConfig withHpoObjective(HPOObjective hpoObjective) {
        this.setHpoObjective(hpoObjective);
        return this;
    }

    public void setHpoResourceConfig(HPOResourceConfig hpoResourceConfig) {
        this.hpoResourceConfig = hpoResourceConfig;
    }

    public HPOResourceConfig getHpoResourceConfig() {
        return this.hpoResourceConfig;
    }

    public HPOConfig withHpoResourceConfig(HPOResourceConfig hpoResourceConfig) {
        this.setHpoResourceConfig(hpoResourceConfig);
        return this;
    }

    public void setAlgorithmHyperParameterRanges(HyperParameterRanges algorithmHyperParameterRanges) {
        this.algorithmHyperParameterRanges = algorithmHyperParameterRanges;
    }

    public HyperParameterRanges getAlgorithmHyperParameterRanges() {
        return this.algorithmHyperParameterRanges;
    }

    public HPOConfig withAlgorithmHyperParameterRanges(HyperParameterRanges algorithmHyperParameterRanges) {
        this.setAlgorithmHyperParameterRanges(algorithmHyperParameterRanges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHpoObjective() != null) {
            sb.append("HpoObjective: ").append(this.getHpoObjective()).append(",");
        }
        if (this.getHpoResourceConfig() != null) {
            sb.append("HpoResourceConfig: ").append(this.getHpoResourceConfig()).append(",");
        }
        if (this.getAlgorithmHyperParameterRanges() != null) {
            sb.append("AlgorithmHyperParameterRanges: ").append(this.getAlgorithmHyperParameterRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOConfig)) {
            return false;
        }
        HPOConfig other = (HPOConfig)obj;
        if (other.getHpoObjective() == null ^ this.getHpoObjective() == null) {
            return false;
        }
        if (other.getHpoObjective() != null && !other.getHpoObjective().equals(this.getHpoObjective())) {
            return false;
        }
        if (other.getHpoResourceConfig() == null ^ this.getHpoResourceConfig() == null) {
            return false;
        }
        if (other.getHpoResourceConfig() != null && !other.getHpoResourceConfig().equals(this.getHpoResourceConfig())) {
            return false;
        }
        if (other.getAlgorithmHyperParameterRanges() == null ^ this.getAlgorithmHyperParameterRanges() == null) {
            return false;
        }
        return other.getAlgorithmHyperParameterRanges() == null || other.getAlgorithmHyperParameterRanges().equals(this.getAlgorithmHyperParameterRanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHpoObjective() == null ? 0 : this.getHpoObjective().hashCode());
        hashCode = 31 * hashCode + (this.getHpoResourceConfig() == null ? 0 : this.getHpoResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmHyperParameterRanges() == null ? 0 : this.getAlgorithmHyperParameterRanges().hashCode());
        return hashCode;
    }

    public HPOConfig clone() {
        try {
            return (HPOConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HPOConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

