/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediaconnect.AWSMediaConnect;
import com.amazonaws.services.mediaconnect.AWSMediaConnectClientBuilder;
import com.amazonaws.services.mediaconnect.model.AWSMediaConnectException;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsResult;
import com.amazonaws.services.mediaconnect.model.CreateFlowRequest;
import com.amazonaws.services.mediaconnect.model.CreateFlowResult;
import com.amazonaws.services.mediaconnect.model.DeleteFlowRequest;
import com.amazonaws.services.mediaconnect.model.DeleteFlowResult;
import com.amazonaws.services.mediaconnect.model.DescribeFlowRequest;
import com.amazonaws.services.mediaconnect.model.DescribeFlowResult;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListFlowsRequest;
import com.amazonaws.services.mediaconnect.model.ListFlowsResult;
import com.amazonaws.services.mediaconnect.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediaconnect.model.ListTagsForResourceResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.StartFlowRequest;
import com.amazonaws.services.mediaconnect.model.StartFlowResult;
import com.amazonaws.services.mediaconnect.model.StopFlowRequest;
import com.amazonaws.services.mediaconnect.model.StopFlowResult;
import com.amazonaws.services.mediaconnect.model.TagResourceRequest;
import com.amazonaws.services.mediaconnect.model.TagResourceResult;
import com.amazonaws.services.mediaconnect.model.UntagResourceRequest;
import com.amazonaws.services.mediaconnect.model.UntagResourceResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceResult;
import com.amazonaws.services.mediaconnect.model.transform.AddFlowOutputs420ExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.AddFlowOutputsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.AddFlowOutputsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.CreateFlow420ExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.CreateFlowRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.CreateFlowResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.DeleteFlowRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.DeleteFlowResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.DescribeFlowRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.DescribeFlowResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.GrantFlowEntitlements420ExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.GrantFlowEntitlementsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.GrantFlowEntitlementsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ListEntitlementsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ListEntitlementsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ListFlowsRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ListFlowsResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.RemoveFlowOutputRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.RemoveFlowOutputResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.RevokeFlowEntitlementRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.RevokeFlowEntitlementResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.StartFlowRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.StartFlowResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.StopFlowRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.StopFlowResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UpdateFlowEntitlementRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UpdateFlowEntitlementResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UpdateFlowOutputRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UpdateFlowOutputResultJsonUnmarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UpdateFlowSourceRequestProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.transform.UpdateFlowSourceResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSMediaConnectClient
extends AmazonWebServiceClient
implements AWSMediaConnect {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaConnect.class);
    private static final String DEFAULT_SIGNING_NAME = "mediaconnect";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CreateFlow420Exception").withExceptionUnmarshaller(CreateFlow420ExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller(NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller(ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GrantFlowEntitlements420Exception").withExceptionUnmarshaller(GrantFlowEntitlements420ExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller(ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AddFlowOutputs420Exception").withExceptionUnmarshaller(AddFlowOutputs420ExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller(TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller(BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller(InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMediaConnectException.class));

    public static AWSMediaConnectClientBuilder builder() {
        return AWSMediaConnectClientBuilder.standard();
    }

    AWSMediaConnectClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaConnectClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mediaconnect.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediaconnect/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediaconnect/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddFlowOutputsResult addFlowOutputs(AddFlowOutputsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAddFlowOutputs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddFlowOutputsResult executeAddFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addFlowOutputsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddFlowOutputsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddFlowOutputsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(addFlowOutputsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AddFlowOutputs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AddFlowOutputsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddFlowOutputsResult addFlowOutputsResult = (AddFlowOutputsResult)response.getAwsResponse();
            return addFlowOutputsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFlowResult createFlow(CreateFlowRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFlowResult executeCreateFlow(CreateFlowRequest createFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFlowRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFlowResult createFlowResult = (CreateFlowResult)response.getAwsResponse();
            return createFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFlowResult deleteFlow(DeleteFlowRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFlowResult executeDeleteFlow(DeleteFlowRequest deleteFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFlowRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFlowResult deleteFlowResult = (DeleteFlowResult)response.getAwsResponse();
            return deleteFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFlowResult describeFlow(DescribeFlowRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFlowResult executeDescribeFlow(DescribeFlowRequest describeFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFlowRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFlowResult describeFlowResult = (DescribeFlowResult)response.getAwsResponse();
            return describeFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GrantFlowEntitlementsResult grantFlowEntitlements(GrantFlowEntitlementsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGrantFlowEntitlements(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GrantFlowEntitlementsResult executeGrantFlowEntitlements(GrantFlowEntitlementsRequest grantFlowEntitlementsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(grantFlowEntitlementsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GrantFlowEntitlementsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GrantFlowEntitlementsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(grantFlowEntitlementsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GrantFlowEntitlements");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GrantFlowEntitlementsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GrantFlowEntitlementsResult grantFlowEntitlementsResult = (GrantFlowEntitlementsResult)response.getAwsResponse();
            return grantFlowEntitlementsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEntitlementsResult listEntitlements(ListEntitlementsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListEntitlements(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEntitlementsResult executeListEntitlements(ListEntitlementsRequest listEntitlementsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEntitlementsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEntitlementsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEntitlementsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listEntitlementsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListEntitlements");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListEntitlementsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEntitlementsResult listEntitlementsResult = (ListEntitlementsResult)response.getAwsResponse();
            return listEntitlementsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFlowsResult listFlows(ListFlowsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListFlows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFlowsResult executeListFlows(ListFlowsRequest listFlowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFlowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFlowsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listFlowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListFlows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListFlowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFlowsResult listFlowsResult = (ListFlowsResult)response.getAwsResponse();
            return listFlowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveFlowOutputResult removeFlowOutput(RemoveFlowOutputRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRemoveFlowOutput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveFlowOutputResult executeRemoveFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeFlowOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveFlowOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveFlowOutputRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(removeFlowOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "RemoveFlowOutput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RemoveFlowOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveFlowOutputResult removeFlowOutputResult = (RemoveFlowOutputResult)response.getAwsResponse();
            return removeFlowOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RevokeFlowEntitlementResult revokeFlowEntitlement(RevokeFlowEntitlementRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRevokeFlowEntitlement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RevokeFlowEntitlementResult executeRevokeFlowEntitlement(RevokeFlowEntitlementRequest revokeFlowEntitlementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(revokeFlowEntitlementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RevokeFlowEntitlementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RevokeFlowEntitlementRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(revokeFlowEntitlementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "RevokeFlowEntitlement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RevokeFlowEntitlementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RevokeFlowEntitlementResult revokeFlowEntitlementResult = (RevokeFlowEntitlementResult)response.getAwsResponse();
            return revokeFlowEntitlementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFlowResult startFlow(StartFlowRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFlowResult executeStartFlow(StartFlowRequest startFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFlowRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFlowResult startFlowResult = (StartFlowResult)response.getAwsResponse();
            return startFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopFlowResult stopFlow(StopFlowRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopFlowResult executeStopFlow(StopFlowRequest stopFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopFlowRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(stopFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StopFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopFlowResult stopFlowResult = (StopFlowResult)response.getAwsResponse();
            return stopFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFlowEntitlementResult updateFlowEntitlement(UpdateFlowEntitlementRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateFlowEntitlement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFlowEntitlementResult executeUpdateFlowEntitlement(UpdateFlowEntitlementRequest updateFlowEntitlementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFlowEntitlementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFlowEntitlementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFlowEntitlementRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateFlowEntitlementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateFlowEntitlement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateFlowEntitlementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFlowEntitlementResult updateFlowEntitlementResult = (UpdateFlowEntitlementResult)response.getAwsResponse();
            return updateFlowEntitlementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFlowOutputResult updateFlowOutput(UpdateFlowOutputRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateFlowOutput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFlowOutputResult executeUpdateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFlowOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFlowOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFlowOutputRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateFlowOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateFlowOutput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateFlowOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFlowOutputResult updateFlowOutputResult = (UpdateFlowOutputResult)response.getAwsResponse();
            return updateFlowOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFlowSourceResult updateFlowSource(UpdateFlowSourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateFlowSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFlowSourceResult executeUpdateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFlowSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFlowSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFlowSourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateFlowSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaConnect");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateFlowSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateFlowSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFlowSourceResult updateFlowSourceResult = (UpdateFlowSourceResult)response.getAwsResponse();
            return updateFlowSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

