/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.marketplacecatalog.model.Filter;
import com.amazonaws.services.marketplacecatalog.model.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEntitiesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalog;
    private String entityType;
    private List<Filter> filterList;
    private Sort sort;
    private String nextToken;
    private Integer maxResults;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public ListEntitiesRequest withCatalog(String catalog) {
        this.setCatalog(catalog);
        return this;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public ListEntitiesRequest withEntityType(String entityType) {
        this.setEntityType(entityType);
        return this;
    }

    public List<Filter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(Collection<Filter> filterList) {
        if (filterList == null) {
            this.filterList = null;
            return;
        }
        this.filterList = new ArrayList<Filter>(filterList);
    }

    public ListEntitiesRequest withFilterList(Filter ... filterList) {
        if (this.filterList == null) {
            this.setFilterList(new ArrayList<Filter>(filterList.length));
        }
        for (Filter ele : filterList) {
            this.filterList.add(ele);
        }
        return this;
    }

    public ListEntitiesRequest withFilterList(Collection<Filter> filterList) {
        this.setFilterList(filterList);
        return this;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Sort getSort() {
        return this.sort;
    }

    public ListEntitiesRequest withSort(Sort sort) {
        this.setSort(sort);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListEntitiesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListEntitiesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalog() != null) {
            sb.append("Catalog: ").append(this.getCatalog()).append(",");
        }
        if (this.getEntityType() != null) {
            sb.append("EntityType: ").append(this.getEntityType()).append(",");
        }
        if (this.getFilterList() != null) {
            sb.append("FilterList: ").append(this.getFilterList()).append(",");
        }
        if (this.getSort() != null) {
            sb.append("Sort: ").append(this.getSort()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesRequest)) {
            return false;
        }
        ListEntitiesRequest other = (ListEntitiesRequest)obj;
        if (other.getCatalog() == null ^ this.getCatalog() == null) {
            return false;
        }
        if (other.getCatalog() != null && !other.getCatalog().equals(this.getCatalog())) {
            return false;
        }
        if (other.getEntityType() == null ^ this.getEntityType() == null) {
            return false;
        }
        if (other.getEntityType() != null && !other.getEntityType().equals(this.getEntityType())) {
            return false;
        }
        if (other.getFilterList() == null ^ this.getFilterList() == null) {
            return false;
        }
        if (other.getFilterList() != null && !other.getFilterList().equals(this.getFilterList())) {
            return false;
        }
        if (other.getSort() == null ^ this.getSort() == null) {
            return false;
        }
        if (other.getSort() != null && !other.getSort().equals(this.getSort())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalog() == null ? 0 : this.getCatalog().hashCode());
        hashCode = 31 * hashCode + (this.getEntityType() == null ? 0 : this.getEntityType().hashCode());
        hashCode = 31 * hashCode + (this.getFilterList() == null ? 0 : this.getFilterList().hashCode());
        hashCode = 31 * hashCode + (this.getSort() == null ? 0 : this.getSort().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListEntitiesRequest clone() {
        return (ListEntitiesRequest)super.clone();
    }
}

