/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogAsync;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogAsyncClientBuilder;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogClient;
import com.amazonaws.services.marketplacecatalog.model.CancelChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.CancelChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.DescribeChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.DescribeChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.DescribeEntityRequest;
import com.amazonaws.services.marketplacecatalog.model.DescribeEntityResult;
import com.amazonaws.services.marketplacecatalog.model.ListChangeSetsRequest;
import com.amazonaws.services.marketplacecatalog.model.ListChangeSetsResult;
import com.amazonaws.services.marketplacecatalog.model.ListEntitiesRequest;
import com.amazonaws.services.marketplacecatalog.model.ListEntitiesResult;
import com.amazonaws.services.marketplacecatalog.model.StartChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.StartChangeSetResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMarketplaceCatalogAsyncClient
extends AWSMarketplaceCatalogClient
implements AWSMarketplaceCatalogAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMarketplaceCatalogAsyncClientBuilder asyncBuilder() {
        return AWSMarketplaceCatalogAsyncClientBuilder.standard();
    }

    AWSMarketplaceCatalogAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelChangeSetResult> cancelChangeSetAsync(CancelChangeSetRequest request) {
        return this.cancelChangeSetAsync(request, null);
    }

    @Override
    public Future<CancelChangeSetResult> cancelChangeSetAsync(CancelChangeSetRequest request, final AsyncHandler<CancelChangeSetRequest, CancelChangeSetResult> asyncHandler) {
        final CancelChangeSetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelChangeSetResult>(){

            @Override
            public CancelChangeSetResult call() throws Exception {
                CancelChangeSetResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeCancelChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChangeSetResult> describeChangeSetAsync(DescribeChangeSetRequest request) {
        return this.describeChangeSetAsync(request, null);
    }

    @Override
    public Future<DescribeChangeSetResult> describeChangeSetAsync(DescribeChangeSetRequest request, final AsyncHandler<DescribeChangeSetRequest, DescribeChangeSetResult> asyncHandler) {
        final DescribeChangeSetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChangeSetResult>(){

            @Override
            public DescribeChangeSetResult call() throws Exception {
                DescribeChangeSetResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeDescribeChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEntityResult> describeEntityAsync(DescribeEntityRequest request) {
        return this.describeEntityAsync(request, null);
    }

    @Override
    public Future<DescribeEntityResult> describeEntityAsync(DescribeEntityRequest request, final AsyncHandler<DescribeEntityRequest, DescribeEntityResult> asyncHandler) {
        final DescribeEntityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEntityResult>(){

            @Override
            public DescribeEntityResult call() throws Exception {
                DescribeEntityResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeDescribeEntity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChangeSetsResult> listChangeSetsAsync(ListChangeSetsRequest request) {
        return this.listChangeSetsAsync(request, null);
    }

    @Override
    public Future<ListChangeSetsResult> listChangeSetsAsync(ListChangeSetsRequest request, final AsyncHandler<ListChangeSetsRequest, ListChangeSetsResult> asyncHandler) {
        final ListChangeSetsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChangeSetsResult>(){

            @Override
            public ListChangeSetsResult call() throws Exception {
                ListChangeSetsResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeListChangeSets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitiesResult> listEntitiesAsync(ListEntitiesRequest request) {
        return this.listEntitiesAsync(request, null);
    }

    @Override
    public Future<ListEntitiesResult> listEntitiesAsync(ListEntitiesRequest request, final AsyncHandler<ListEntitiesRequest, ListEntitiesResult> asyncHandler) {
        final ListEntitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitiesResult>(){

            @Override
            public ListEntitiesResult call() throws Exception {
                ListEntitiesResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeListEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartChangeSetResult> startChangeSetAsync(StartChangeSetRequest request) {
        return this.startChangeSetAsync(request, null);
    }

    @Override
    public Future<StartChangeSetResult> startChangeSetAsync(StartChangeSetRequest request, final AsyncHandler<StartChangeSetRequest, StartChangeSetResult> asyncHandler) {
        final StartChangeSetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartChangeSetResult>(){

            @Override
            public StartChangeSetResult call() throws Exception {
                StartChangeSetResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeStartChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

