/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.managedblockchain.AmazonManagedBlockchainAsync;
import com.amazonaws.services.managedblockchain.AmazonManagedBlockchainAsyncClientBuilder;
import com.amazonaws.services.managedblockchain.AmazonManagedBlockchainClient;
import com.amazonaws.services.managedblockchain.model.CreateMemberRequest;
import com.amazonaws.services.managedblockchain.model.CreateMemberResult;
import com.amazonaws.services.managedblockchain.model.CreateNetworkRequest;
import com.amazonaws.services.managedblockchain.model.CreateNetworkResult;
import com.amazonaws.services.managedblockchain.model.CreateNodeRequest;
import com.amazonaws.services.managedblockchain.model.CreateNodeResult;
import com.amazonaws.services.managedblockchain.model.CreateProposalRequest;
import com.amazonaws.services.managedblockchain.model.CreateProposalResult;
import com.amazonaws.services.managedblockchain.model.DeleteMemberRequest;
import com.amazonaws.services.managedblockchain.model.DeleteMemberResult;
import com.amazonaws.services.managedblockchain.model.DeleteNodeRequest;
import com.amazonaws.services.managedblockchain.model.DeleteNodeResult;
import com.amazonaws.services.managedblockchain.model.GetMemberRequest;
import com.amazonaws.services.managedblockchain.model.GetMemberResult;
import com.amazonaws.services.managedblockchain.model.GetNetworkRequest;
import com.amazonaws.services.managedblockchain.model.GetNetworkResult;
import com.amazonaws.services.managedblockchain.model.GetNodeRequest;
import com.amazonaws.services.managedblockchain.model.GetNodeResult;
import com.amazonaws.services.managedblockchain.model.GetProposalRequest;
import com.amazonaws.services.managedblockchain.model.GetProposalResult;
import com.amazonaws.services.managedblockchain.model.ListInvitationsRequest;
import com.amazonaws.services.managedblockchain.model.ListInvitationsResult;
import com.amazonaws.services.managedblockchain.model.ListMembersRequest;
import com.amazonaws.services.managedblockchain.model.ListMembersResult;
import com.amazonaws.services.managedblockchain.model.ListNetworksRequest;
import com.amazonaws.services.managedblockchain.model.ListNetworksResult;
import com.amazonaws.services.managedblockchain.model.ListNodesRequest;
import com.amazonaws.services.managedblockchain.model.ListNodesResult;
import com.amazonaws.services.managedblockchain.model.ListProposalVotesRequest;
import com.amazonaws.services.managedblockchain.model.ListProposalVotesResult;
import com.amazonaws.services.managedblockchain.model.ListProposalsRequest;
import com.amazonaws.services.managedblockchain.model.ListProposalsResult;
import com.amazonaws.services.managedblockchain.model.RejectInvitationRequest;
import com.amazonaws.services.managedblockchain.model.RejectInvitationResult;
import com.amazonaws.services.managedblockchain.model.VoteOnProposalRequest;
import com.amazonaws.services.managedblockchain.model.VoteOnProposalResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonManagedBlockchainAsyncClient
extends AmazonManagedBlockchainClient
implements AmazonManagedBlockchainAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonManagedBlockchainAsyncClientBuilder asyncBuilder() {
        return AmazonManagedBlockchainAsyncClientBuilder.standard();
    }

    AmazonManagedBlockchainAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateMemberResult> createMemberAsync(CreateMemberRequest request) {
        return this.createMemberAsync(request, null);
    }

    @Override
    public Future<CreateMemberResult> createMemberAsync(CreateMemberRequest request, final AsyncHandler<CreateMemberRequest, CreateMemberResult> asyncHandler) {
        final CreateMemberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMemberResult>(){

            @Override
            public CreateMemberResult call() throws Exception {
                CreateMemberResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeCreateMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNetworkResult> createNetworkAsync(CreateNetworkRequest request) {
        return this.createNetworkAsync(request, null);
    }

    @Override
    public Future<CreateNetworkResult> createNetworkAsync(CreateNetworkRequest request, final AsyncHandler<CreateNetworkRequest, CreateNetworkResult> asyncHandler) {
        final CreateNetworkRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNetworkResult>(){

            @Override
            public CreateNetworkResult call() throws Exception {
                CreateNetworkResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeCreateNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNodeResult> createNodeAsync(CreateNodeRequest request) {
        return this.createNodeAsync(request, null);
    }

    @Override
    public Future<CreateNodeResult> createNodeAsync(CreateNodeRequest request, final AsyncHandler<CreateNodeRequest, CreateNodeResult> asyncHandler) {
        final CreateNodeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNodeResult>(){

            @Override
            public CreateNodeResult call() throws Exception {
                CreateNodeResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeCreateNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProposalResult> createProposalAsync(CreateProposalRequest request) {
        return this.createProposalAsync(request, null);
    }

    @Override
    public Future<CreateProposalResult> createProposalAsync(CreateProposalRequest request, final AsyncHandler<CreateProposalRequest, CreateProposalResult> asyncHandler) {
        final CreateProposalRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProposalResult>(){

            @Override
            public CreateProposalResult call() throws Exception {
                CreateProposalResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeCreateProposal(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMemberResult> deleteMemberAsync(DeleteMemberRequest request) {
        return this.deleteMemberAsync(request, null);
    }

    @Override
    public Future<DeleteMemberResult> deleteMemberAsync(DeleteMemberRequest request, final AsyncHandler<DeleteMemberRequest, DeleteMemberResult> asyncHandler) {
        final DeleteMemberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMemberResult>(){

            @Override
            public DeleteMemberResult call() throws Exception {
                DeleteMemberResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeDeleteMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNodeResult> deleteNodeAsync(DeleteNodeRequest request) {
        return this.deleteNodeAsync(request, null);
    }

    @Override
    public Future<DeleteNodeResult> deleteNodeAsync(DeleteNodeRequest request, final AsyncHandler<DeleteNodeRequest, DeleteNodeResult> asyncHandler) {
        final DeleteNodeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNodeResult>(){

            @Override
            public DeleteNodeResult call() throws Exception {
                DeleteNodeResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeDeleteNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMemberResult> getMemberAsync(GetMemberRequest request) {
        return this.getMemberAsync(request, null);
    }

    @Override
    public Future<GetMemberResult> getMemberAsync(GetMemberRequest request, final AsyncHandler<GetMemberRequest, GetMemberResult> asyncHandler) {
        final GetMemberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMemberResult>(){

            @Override
            public GetMemberResult call() throws Exception {
                GetMemberResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeGetMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkResult> getNetworkAsync(GetNetworkRequest request) {
        return this.getNetworkAsync(request, null);
    }

    @Override
    public Future<GetNetworkResult> getNetworkAsync(GetNetworkRequest request, final AsyncHandler<GetNetworkRequest, GetNetworkResult> asyncHandler) {
        final GetNetworkRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkResult>(){

            @Override
            public GetNetworkResult call() throws Exception {
                GetNetworkResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeGetNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNodeResult> getNodeAsync(GetNodeRequest request) {
        return this.getNodeAsync(request, null);
    }

    @Override
    public Future<GetNodeResult> getNodeAsync(GetNodeRequest request, final AsyncHandler<GetNodeRequest, GetNodeResult> asyncHandler) {
        final GetNodeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNodeResult>(){

            @Override
            public GetNodeResult call() throws Exception {
                GetNodeResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeGetNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProposalResult> getProposalAsync(GetProposalRequest request) {
        return this.getProposalAsync(request, null);
    }

    @Override
    public Future<GetProposalResult> getProposalAsync(GetProposalRequest request, final AsyncHandler<GetProposalRequest, GetProposalResult> asyncHandler) {
        final GetProposalRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProposalResult>(){

            @Override
            public GetProposalResult call() throws Exception {
                GetProposalResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeGetProposal(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request) {
        return this.listInvitationsAsync(request, null);
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request, final AsyncHandler<ListInvitationsRequest, ListInvitationsResult> asyncHandler) {
        final ListInvitationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInvitationsResult>(){

            @Override
            public ListInvitationsResult call() throws Exception {
                ListInvitationsResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeListInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request) {
        return this.listMembersAsync(request, null);
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request, final AsyncHandler<ListMembersRequest, ListMembersResult> asyncHandler) {
        final ListMembersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMembersResult>(){

            @Override
            public ListMembersResult call() throws Exception {
                ListMembersResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeListMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNetworksResult> listNetworksAsync(ListNetworksRequest request) {
        return this.listNetworksAsync(request, null);
    }

    @Override
    public Future<ListNetworksResult> listNetworksAsync(ListNetworksRequest request, final AsyncHandler<ListNetworksRequest, ListNetworksResult> asyncHandler) {
        final ListNetworksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNetworksResult>(){

            @Override
            public ListNetworksResult call() throws Exception {
                ListNetworksResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeListNetworks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request) {
        return this.listNodesAsync(request, null);
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request, final AsyncHandler<ListNodesRequest, ListNodesResult> asyncHandler) {
        final ListNodesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNodesResult>(){

            @Override
            public ListNodesResult call() throws Exception {
                ListNodesResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeListNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProposalVotesResult> listProposalVotesAsync(ListProposalVotesRequest request) {
        return this.listProposalVotesAsync(request, null);
    }

    @Override
    public Future<ListProposalVotesResult> listProposalVotesAsync(ListProposalVotesRequest request, final AsyncHandler<ListProposalVotesRequest, ListProposalVotesResult> asyncHandler) {
        final ListProposalVotesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProposalVotesResult>(){

            @Override
            public ListProposalVotesResult call() throws Exception {
                ListProposalVotesResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeListProposalVotes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProposalsResult> listProposalsAsync(ListProposalsRequest request) {
        return this.listProposalsAsync(request, null);
    }

    @Override
    public Future<ListProposalsResult> listProposalsAsync(ListProposalsRequest request, final AsyncHandler<ListProposalsRequest, ListProposalsResult> asyncHandler) {
        final ListProposalsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProposalsResult>(){

            @Override
            public ListProposalsResult call() throws Exception {
                ListProposalsResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeListProposals(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectInvitationResult> rejectInvitationAsync(RejectInvitationRequest request) {
        return this.rejectInvitationAsync(request, null);
    }

    @Override
    public Future<RejectInvitationResult> rejectInvitationAsync(RejectInvitationRequest request, final AsyncHandler<RejectInvitationRequest, RejectInvitationResult> asyncHandler) {
        final RejectInvitationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectInvitationResult>(){

            @Override
            public RejectInvitationResult call() throws Exception {
                RejectInvitationResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeRejectInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VoteOnProposalResult> voteOnProposalAsync(VoteOnProposalRequest request) {
        return this.voteOnProposalAsync(request, null);
    }

    @Override
    public Future<VoteOnProposalResult> voteOnProposalAsync(VoteOnProposalRequest request, final AsyncHandler<VoteOnProposalRequest, VoteOnProposalResult> asyncHandler) {
        final VoteOnProposalRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VoteOnProposalResult>(){

            @Override
            public VoteOnProposalResult call() throws Exception {
                VoteOnProposalResult result = null;
                try {
                    result = AmazonManagedBlockchainAsyncClient.this.executeVoteOnProposal(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

