/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.Input;

@SdkInternalApi
public class InputMarshaller {
    private static final MarshallingInfo<String> NAMEPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefix").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputProcessingConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsInput").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseInput").build();
    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISM_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParallelism").build();
    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema").build();
    private static final InputMarshaller instance = new InputMarshaller();

    public static InputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Input input, ProtocolMarshaller protocolMarshaller) {
        if (input == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(input.getNamePrefix(), NAMEPREFIX_BINDING);
            protocolMarshaller.marshall(input.getInputProcessingConfiguration(), INPUTPROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(input.getKinesisStreamsInput(), KINESISSTREAMSINPUT_BINDING);
            protocolMarshaller.marshall(input.getKinesisFirehoseInput(), KINESISFIREHOSEINPUT_BINDING);
            protocolMarshaller.marshall(input.getInputParallelism(), INPUTPARALLELISM_BINDING);
            protocolMarshaller.marshall(input.getInputSchema(), INPUTSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

