/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.CodeContent;
import java.nio.ByteBuffer;

@SdkInternalApi
public class CodeContentMarshaller {
    private static final MarshallingInfo<String> TEXTCONTENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextContent").build();
    private static final MarshallingInfo<ByteBuffer> ZIPFILECONTENT_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipFileContent").build();
    private static final MarshallingInfo<StructuredPojo> S3CONTENTLOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ContentLocation").build();
    private static final CodeContentMarshaller instance = new CodeContentMarshaller();

    public static CodeContentMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeContent codeContent, ProtocolMarshaller protocolMarshaller) {
        if (codeContent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(codeContent.getTextContent(), TEXTCONTENT_BINDING);
            protocolMarshaller.marshall(codeContent.getZipFileContent(), ZIPFILECONTENT_BINDING);
            protocolMarshaller.marshall(codeContent.getS3ContentLocation(), S3CONTENTLOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

