/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.services.kinesisanalyticsv2.model.CodeContent;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.S3ContentLocationJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.nio.ByteBuffer;

public class CodeContentJsonUnmarshaller
implements Unmarshaller<CodeContent, JsonUnmarshallerContext> {
    private static CodeContentJsonUnmarshaller instance;

    @Override
    public CodeContent unmarshall(JsonUnmarshallerContext context) throws Exception {
        CodeContent codeContent = new CodeContent();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TextContent", targetDepth)) {
                    context.nextToken();
                    codeContent.setTextContent(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ZipFileContent", targetDepth)) {
                    context.nextToken();
                    codeContent.setZipFileContent(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("S3ContentLocation", targetDepth)) {
                    context.nextToken();
                    codeContent.setS3ContentLocation(S3ContentLocationJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return codeContent;
    }

    public static CodeContentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CodeContentJsonUnmarshaller();
        }
        return instance;
    }
}

