/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration;

@SdkInternalApi
public class ApplicationCodeConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CODECONTENT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeContent").build();
    private static final MarshallingInfo<String> CODECONTENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeContentType").build();
    private static final ApplicationCodeConfigurationMarshaller instance = new ApplicationCodeConfigurationMarshaller();

    public static ApplicationCodeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ApplicationCodeConfiguration applicationCodeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (applicationCodeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(applicationCodeConfiguration.getCodeContent(), CODECONTENT_BINDING);
            protocolMarshaller.marshall(applicationCodeConfiguration.getCodeContentType(), CODECONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

