/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.Input;
import com.amazonaws.services.kinesisanalyticsv2.model.Output;
import com.amazonaws.services.kinesisanalyticsv2.model.ReferenceDataSource;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.SqlApplicationConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlApplicationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Input> inputs;
    private List<Output> outputs;
    private List<ReferenceDataSource> referenceDataSources;

    public List<Input> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<Input> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<Input>(inputs);
    }

    public SqlApplicationConfiguration withInputs(Input ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<Input>(inputs.length));
        }
        for (Input ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public SqlApplicationConfiguration withInputs(Collection<Input> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<Output>(outputs);
    }

    public SqlApplicationConfiguration withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public SqlApplicationConfiguration withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public List<ReferenceDataSource> getReferenceDataSources() {
        return this.referenceDataSources;
    }

    public void setReferenceDataSources(Collection<ReferenceDataSource> referenceDataSources) {
        if (referenceDataSources == null) {
            this.referenceDataSources = null;
            return;
        }
        this.referenceDataSources = new ArrayList<ReferenceDataSource>(referenceDataSources);
    }

    public SqlApplicationConfiguration withReferenceDataSources(ReferenceDataSource ... referenceDataSources) {
        if (this.referenceDataSources == null) {
            this.setReferenceDataSources(new ArrayList<ReferenceDataSource>(referenceDataSources.length));
        }
        for (ReferenceDataSource ele : referenceDataSources) {
            this.referenceDataSources.add(ele);
        }
        return this;
    }

    public SqlApplicationConfiguration withReferenceDataSources(Collection<ReferenceDataSource> referenceDataSources) {
        this.setReferenceDataSources(referenceDataSources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getReferenceDataSources() != null) {
            sb.append("ReferenceDataSources: ").append(this.getReferenceDataSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlApplicationConfiguration)) {
            return false;
        }
        SqlApplicationConfiguration other = (SqlApplicationConfiguration)obj;
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getReferenceDataSources() == null ^ this.getReferenceDataSources() == null) {
            return false;
        }
        return other.getReferenceDataSources() == null || other.getReferenceDataSources().equals(this.getReferenceDataSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceDataSources() == null ? 0 : this.getReferenceDataSources().hashCode());
        return hashCode;
    }

    public SqlApplicationConfiguration clone() {
        try {
            return (SqlApplicationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqlApplicationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

