/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.PropertyGroupMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PropertyGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String propertyGroupId;
    private Map<String, String> propertyMap;

    public void setPropertyGroupId(String propertyGroupId) {
        this.propertyGroupId = propertyGroupId;
    }

    public String getPropertyGroupId() {
        return this.propertyGroupId;
    }

    public PropertyGroup withPropertyGroupId(String propertyGroupId) {
        this.setPropertyGroupId(propertyGroupId);
        return this;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(Map<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public PropertyGroup withPropertyMap(Map<String, String> propertyMap) {
        this.setPropertyMap(propertyMap);
        return this;
    }

    public PropertyGroup addPropertyMapEntry(String key, String value) {
        if (null == this.propertyMap) {
            this.propertyMap = new HashMap<String, String>();
        }
        if (this.propertyMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.propertyMap.put(key, value);
        return this;
    }

    public PropertyGroup clearPropertyMapEntries() {
        this.propertyMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPropertyGroupId() != null) {
            sb.append("PropertyGroupId: ").append(this.getPropertyGroupId()).append(",");
        }
        if (this.getPropertyMap() != null) {
            sb.append("PropertyMap: ").append(this.getPropertyMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyGroup)) {
            return false;
        }
        PropertyGroup other = (PropertyGroup)obj;
        if (other.getPropertyGroupId() == null ^ this.getPropertyGroupId() == null) {
            return false;
        }
        if (other.getPropertyGroupId() != null && !other.getPropertyGroupId().equals(this.getPropertyGroupId())) {
            return false;
        }
        if (other.getPropertyMap() == null ^ this.getPropertyMap() == null) {
            return false;
        }
        return other.getPropertyMap() == null || other.getPropertyMap().equals(this.getPropertyMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPropertyGroupId() == null ? 0 : this.getPropertyGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyMap() == null ? 0 : this.getPropertyMap().hashCode());
        return hashCode;
    }

    public PropertyGroup clone() {
        try {
            return (PropertyGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PropertyGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

