/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.Tls;
import java.util.List;

@SdkInternalApi
public class TlsMarshaller {
    private static final MarshallingInfo<List> CERTIFICATEAUTHORITYARNLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateAuthorityArnList").build();
    private static final TlsMarshaller instance = new TlsMarshaller();

    public static TlsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Tls tls, ProtocolMarshaller protocolMarshaller) {
        if (tls == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tls.getCertificateAuthorityArnList(), CERTIFICATEAUTHORITYARNLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

