/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.NodeInfo;

@SdkInternalApi
public class NodeInfoMarshaller {
    private static final MarshallingInfo<String> ADDEDTOCLUSTERTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addedToClusterTime").build();
    private static final MarshallingInfo<StructuredPojo> BROKERNODEINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerNodeInfo").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").build();
    private static final MarshallingInfo<String> NODEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeARN").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeType").build();
    private static final MarshallingInfo<StructuredPojo> ZOOKEEPERNODEINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("zookeeperNodeInfo").build();
    private static final NodeInfoMarshaller instance = new NodeInfoMarshaller();

    public static NodeInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(NodeInfo nodeInfo, ProtocolMarshaller protocolMarshaller) {
        if (nodeInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(nodeInfo.getAddedToClusterTime(), ADDEDTOCLUSTERTIME_BINDING);
            protocolMarshaller.marshall(nodeInfo.getBrokerNodeInfo(), BROKERNODEINFO_BINDING);
            protocolMarshaller.marshall(nodeInfo.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(nodeInfo.getNodeARN(), NODEARN_BINDING);
            protocolMarshaller.marshall(nodeInfo.getNodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall(nodeInfo.getZookeeperNodeInfo(), ZOOKEEPERNODEINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

