/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.EncryptionInTransit;

@SdkInternalApi
public class EncryptionInTransitMarshaller {
    private static final MarshallingInfo<String> CLIENTBROKER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientBroker").build();
    private static final MarshallingInfo<Boolean> INCLUSTER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inCluster").build();
    private static final EncryptionInTransitMarshaller instance = new EncryptionInTransitMarshaller();

    public static EncryptionInTransitMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionInTransit encryptionInTransit, ProtocolMarshaller protocolMarshaller) {
        if (encryptionInTransit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(encryptionInTransit.getClientBroker(), CLIENTBROKER_BINDING);
            protocolMarshaller.marshall(encryptionInTransit.getInCluster(), INCLUSTER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

