/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.BrokerNodeInfo;
import java.util.List;

@SdkInternalApi
public class BrokerNodeInfoMarshaller {
    private static final MarshallingInfo<String> ATTACHEDENIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedENIId").build();
    private static final MarshallingInfo<Double> BROKERID_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerId").build();
    private static final MarshallingInfo<String> CLIENTSUBNET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientSubnet").build();
    private static final MarshallingInfo<String> CLIENTVPCIPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientVpcIpAddress").build();
    private static final MarshallingInfo<StructuredPojo> CURRENTBROKERSOFTWAREINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentBrokerSoftwareInfo").build();
    private static final MarshallingInfo<List> ENDPOINTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoints").build();
    private static final BrokerNodeInfoMarshaller instance = new BrokerNodeInfoMarshaller();

    public static BrokerNodeInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(BrokerNodeInfo brokerNodeInfo, ProtocolMarshaller protocolMarshaller) {
        if (brokerNodeInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(brokerNodeInfo.getAttachedENIId(), ATTACHEDENIID_BINDING);
            protocolMarshaller.marshall(brokerNodeInfo.getBrokerId(), BROKERID_BINDING);
            protocolMarshaller.marshall(brokerNodeInfo.getClientSubnet(), CLIENTSUBNET_BINDING);
            protocolMarshaller.marshall(brokerNodeInfo.getClientVpcIpAddress(), CLIENTVPCIPADDRESS_BINDING);
            protocolMarshaller.marshall(brokerNodeInfo.getCurrentBrokerSoftwareInfo(), CURRENTBROKERSOFTWAREINFO_BINDING);
            protocolMarshaller.marshall(brokerNodeInfo.getEndpoints(), ENDPOINTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

