/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.BrokerSoftwareInfo;
import com.amazonaws.services.kafka.model.transform.BrokerNodeInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BrokerNodeInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String attachedENIId;
    private Double brokerId;
    private String clientSubnet;
    private String clientVpcIpAddress;
    private BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private List<String> endpoints;

    public void setAttachedENIId(String attachedENIId) {
        this.attachedENIId = attachedENIId;
    }

    public String getAttachedENIId() {
        return this.attachedENIId;
    }

    public BrokerNodeInfo withAttachedENIId(String attachedENIId) {
        this.setAttachedENIId(attachedENIId);
        return this;
    }

    public void setBrokerId(Double brokerId) {
        this.brokerId = brokerId;
    }

    public Double getBrokerId() {
        return this.brokerId;
    }

    public BrokerNodeInfo withBrokerId(Double brokerId) {
        this.setBrokerId(brokerId);
        return this;
    }

    public void setClientSubnet(String clientSubnet) {
        this.clientSubnet = clientSubnet;
    }

    public String getClientSubnet() {
        return this.clientSubnet;
    }

    public BrokerNodeInfo withClientSubnet(String clientSubnet) {
        this.setClientSubnet(clientSubnet);
        return this;
    }

    public void setClientVpcIpAddress(String clientVpcIpAddress) {
        this.clientVpcIpAddress = clientVpcIpAddress;
    }

    public String getClientVpcIpAddress() {
        return this.clientVpcIpAddress;
    }

    public BrokerNodeInfo withClientVpcIpAddress(String clientVpcIpAddress) {
        this.setClientVpcIpAddress(clientVpcIpAddress);
        return this;
    }

    public void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
        this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
    }

    public BrokerSoftwareInfo getCurrentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public BrokerNodeInfo withCurrentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
        this.setCurrentBrokerSoftwareInfo(currentBrokerSoftwareInfo);
        return this;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Collection<String> endpoints) {
        if (endpoints == null) {
            this.endpoints = null;
            return;
        }
        this.endpoints = new ArrayList<String>(endpoints);
    }

    public BrokerNodeInfo withEndpoints(String ... endpoints) {
        if (this.endpoints == null) {
            this.setEndpoints(new ArrayList<String>(endpoints.length));
        }
        for (String ele : endpoints) {
            this.endpoints.add(ele);
        }
        return this;
    }

    public BrokerNodeInfo withEndpoints(Collection<String> endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachedENIId() != null) {
            sb.append("AttachedENIId: ").append(this.getAttachedENIId()).append(",");
        }
        if (this.getBrokerId() != null) {
            sb.append("BrokerId: ").append(this.getBrokerId()).append(",");
        }
        if (this.getClientSubnet() != null) {
            sb.append("ClientSubnet: ").append(this.getClientSubnet()).append(",");
        }
        if (this.getClientVpcIpAddress() != null) {
            sb.append("ClientVpcIpAddress: ").append(this.getClientVpcIpAddress()).append(",");
        }
        if (this.getCurrentBrokerSoftwareInfo() != null) {
            sb.append("CurrentBrokerSoftwareInfo: ").append(this.getCurrentBrokerSoftwareInfo()).append(",");
        }
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeInfo)) {
            return false;
        }
        BrokerNodeInfo other = (BrokerNodeInfo)obj;
        if (other.getAttachedENIId() == null ^ this.getAttachedENIId() == null) {
            return false;
        }
        if (other.getAttachedENIId() != null && !other.getAttachedENIId().equals(this.getAttachedENIId())) {
            return false;
        }
        if (other.getBrokerId() == null ^ this.getBrokerId() == null) {
            return false;
        }
        if (other.getBrokerId() != null && !other.getBrokerId().equals(this.getBrokerId())) {
            return false;
        }
        if (other.getClientSubnet() == null ^ this.getClientSubnet() == null) {
            return false;
        }
        if (other.getClientSubnet() != null && !other.getClientSubnet().equals(this.getClientSubnet())) {
            return false;
        }
        if (other.getClientVpcIpAddress() == null ^ this.getClientVpcIpAddress() == null) {
            return false;
        }
        if (other.getClientVpcIpAddress() != null && !other.getClientVpcIpAddress().equals(this.getClientVpcIpAddress())) {
            return false;
        }
        if (other.getCurrentBrokerSoftwareInfo() == null ^ this.getCurrentBrokerSoftwareInfo() == null) {
            return false;
        }
        if (other.getCurrentBrokerSoftwareInfo() != null && !other.getCurrentBrokerSoftwareInfo().equals(this.getCurrentBrokerSoftwareInfo())) {
            return false;
        }
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        return other.getEndpoints() == null || other.getEndpoints().equals(this.getEndpoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachedENIId() == null ? 0 : this.getAttachedENIId().hashCode());
        hashCode = 31 * hashCode + (this.getBrokerId() == null ? 0 : this.getBrokerId().hashCode());
        hashCode = 31 * hashCode + (this.getClientSubnet() == null ? 0 : this.getClientSubnet().hashCode());
        hashCode = 31 * hashCode + (this.getClientVpcIpAddress() == null ? 0 : this.getClientVpcIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentBrokerSoftwareInfo() == null ? 0 : this.getCurrentBrokerSoftwareInfo().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        return hashCode;
    }

    public BrokerNodeInfo clone() {
        try {
            return (BrokerNodeInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerNodeInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

