/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotthingsgraph.model.DefinitionDocument;

@SdkInternalApi
public class DefinitionDocumentMarshaller {
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("text").build();
    private static final DefinitionDocumentMarshaller instance = new DefinitionDocumentMarshaller();

    public static DefinitionDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(DefinitionDocument definitionDocument, ProtocolMarshaller protocolMarshaller) {
        if (definitionDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(definitionDocument.getLanguage(), LANGUAGE_BINDING);
            protocolMarshaller.marshall(definitionDocument.getText(), TEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

