/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ioteventsdata;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataAsync;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataAsyncClientBuilder;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataClient;
import com.amazonaws.services.ioteventsdata.model.BatchPutMessageRequest;
import com.amazonaws.services.ioteventsdata.model.BatchPutMessageResult;
import com.amazonaws.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.BatchUpdateDetectorResult;
import com.amazonaws.services.ioteventsdata.model.DescribeDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.DescribeDetectorResult;
import com.amazonaws.services.ioteventsdata.model.ListDetectorsRequest;
import com.amazonaws.services.ioteventsdata.model.ListDetectorsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTEventsDataAsyncClient
extends AWSIoTEventsDataClient
implements AWSIoTEventsDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTEventsDataAsyncClientBuilder asyncBuilder() {
        return AWSIoTEventsDataAsyncClientBuilder.standard();
    }

    AWSIoTEventsDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchPutMessageResult> batchPutMessageAsync(BatchPutMessageRequest request) {
        return this.batchPutMessageAsync(request, null);
    }

    @Override
    public Future<BatchPutMessageResult> batchPutMessageAsync(BatchPutMessageRequest request, final AsyncHandler<BatchPutMessageRequest, BatchPutMessageResult> asyncHandler) {
        final BatchPutMessageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchPutMessageResult>(){

            @Override
            public BatchPutMessageResult call() throws Exception {
                BatchPutMessageResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchPutMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateDetectorResult> batchUpdateDetectorAsync(BatchUpdateDetectorRequest request) {
        return this.batchUpdateDetectorAsync(request, null);
    }

    @Override
    public Future<BatchUpdateDetectorResult> batchUpdateDetectorAsync(BatchUpdateDetectorRequest request, final AsyncHandler<BatchUpdateDetectorRequest, BatchUpdateDetectorResult> asyncHandler) {
        final BatchUpdateDetectorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateDetectorResult>(){

            @Override
            public BatchUpdateDetectorResult call() throws Exception {
                BatchUpdateDetectorResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchUpdateDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request) {
        return this.describeDetectorAsync(request, null);
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request, final AsyncHandler<DescribeDetectorRequest, DescribeDetectorResult> asyncHandler) {
        final DescribeDetectorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDetectorResult>(){

            @Override
            public DescribeDetectorResult call() throws Exception {
                DescribeDetectorResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeDescribeDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDetectorsResult> listDetectorsAsync(ListDetectorsRequest request) {
        return this.listDetectorsAsync(request, null);
    }

    @Override
    public Future<ListDetectorsResult> listDetectorsAsync(ListDetectorsRequest request, final AsyncHandler<ListDetectorsRequest, ListDetectorsResult> asyncHandler) {
        final ListDetectorsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDetectorsResult>(){

            @Override
            public ListDetectorsResult call() throws Exception {
                ListDetectorsResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeListDetectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

