/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotevents.model.InputConfiguration;
import java.util.Date;

@SdkInternalApi
public class InputConfigurationMarshaller {
    private static final MarshallingInfo<String> INPUTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputName").build();
    private static final MarshallingInfo<String> INPUTDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputDescription").build();
    private static final MarshallingInfo<String> INPUTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputArn").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final InputConfigurationMarshaller instance = new InputConfigurationMarshaller();

    public static InputConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputConfiguration inputConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (inputConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inputConfiguration.getInputName(), INPUTNAME_BINDING);
            protocolMarshaller.marshall(inputConfiguration.getInputDescription(), INPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(inputConfiguration.getInputArn(), INPUTARN_BINDING);
            protocolMarshaller.marshall(inputConfiguration.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(inputConfiguration.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall(inputConfiguration.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

