/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotevents.model.DetectorDebugOption;
import com.amazonaws.services.iotevents.model.LoggingLevel;
import com.amazonaws.services.iotevents.model.transform.LoggingOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoggingOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleArn;
    private String level;
    private Boolean enabled;
    private List<DetectorDebugOption> detectorDebugOptions;

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public LoggingOptions withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public LoggingOptions withLevel(String level) {
        this.setLevel(level);
        return this;
    }

    public LoggingOptions withLevel(LoggingLevel level) {
        this.level = level.toString();
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public LoggingOptions withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<DetectorDebugOption> getDetectorDebugOptions() {
        return this.detectorDebugOptions;
    }

    public void setDetectorDebugOptions(Collection<DetectorDebugOption> detectorDebugOptions) {
        if (detectorDebugOptions == null) {
            this.detectorDebugOptions = null;
            return;
        }
        this.detectorDebugOptions = new ArrayList<DetectorDebugOption>(detectorDebugOptions);
    }

    public LoggingOptions withDetectorDebugOptions(DetectorDebugOption ... detectorDebugOptions) {
        if (this.detectorDebugOptions == null) {
            this.setDetectorDebugOptions(new ArrayList<DetectorDebugOption>(detectorDebugOptions.length));
        }
        for (DetectorDebugOption ele : detectorDebugOptions) {
            this.detectorDebugOptions.add(ele);
        }
        return this;
    }

    public LoggingOptions withDetectorDebugOptions(Collection<DetectorDebugOption> detectorDebugOptions) {
        this.setDetectorDebugOptions(detectorDebugOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getLevel() != null) {
            sb.append("Level: ").append(this.getLevel()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getDetectorDebugOptions() != null) {
            sb.append("DetectorDebugOptions: ").append(this.getDetectorDebugOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingOptions)) {
            return false;
        }
        LoggingOptions other = (LoggingOptions)obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getLevel() == null ^ this.getLevel() == null) {
            return false;
        }
        if (other.getLevel() != null && !other.getLevel().equals(this.getLevel())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getDetectorDebugOptions() == null ^ this.getDetectorDebugOptions() == null) {
            return false;
        }
        return other.getDetectorDebugOptions() == null || other.getDetectorDebugOptions().equals(this.getDetectorDebugOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getLevel() == null ? 0 : this.getLevel().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getDetectorDebugOptions() == null ? 0 : this.getDetectorDebugOptions().hashCode());
        return hashCode;
    }

    public LoggingOptions clone() {
        try {
            return (LoggingOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

