/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotevents.model.State;
import com.amazonaws.services.iotevents.model.transform.DetectorModelDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectorModelDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<State> states;
    private String initialStateName;

    public List<State> getStates() {
        return this.states;
    }

    public void setStates(Collection<State> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<State>(states);
    }

    public DetectorModelDefinition withStates(State ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<State>(states.length));
        }
        for (State ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public DetectorModelDefinition withStates(Collection<State> states) {
        this.setStates(states);
        return this;
    }

    public void setInitialStateName(String initialStateName) {
        this.initialStateName = initialStateName;
    }

    public String getInitialStateName() {
        return this.initialStateName;
    }

    public DetectorModelDefinition withInitialStateName(String initialStateName) {
        this.setInitialStateName(initialStateName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getInitialStateName() != null) {
            sb.append("InitialStateName: ").append(this.getInitialStateName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelDefinition)) {
            return false;
        }
        DetectorModelDefinition other = (DetectorModelDefinition)obj;
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getInitialStateName() == null ^ this.getInitialStateName() == null) {
            return false;
        }
        return other.getInitialStateName() == null || other.getInitialStateName().equals(this.getInitialStateName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getInitialStateName() == null ? 0 : this.getInitialStateName().hashCode());
        return hashCode;
    }

    public DetectorModelDefinition clone() {
        try {
            return (DetectorModelDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DetectorModelDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

