/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.groundstation.AWSGroundStationAsync;
import com.amazonaws.services.groundstation.AWSGroundStationAsyncClientBuilder;
import com.amazonaws.services.groundstation.AWSGroundStationClient;
import com.amazonaws.services.groundstation.model.CancelContactRequest;
import com.amazonaws.services.groundstation.model.CancelContactResult;
import com.amazonaws.services.groundstation.model.CreateConfigRequest;
import com.amazonaws.services.groundstation.model.CreateConfigResult;
import com.amazonaws.services.groundstation.model.CreateDataflowEndpointGroupRequest;
import com.amazonaws.services.groundstation.model.CreateDataflowEndpointGroupResult;
import com.amazonaws.services.groundstation.model.CreateMissionProfileRequest;
import com.amazonaws.services.groundstation.model.CreateMissionProfileResult;
import com.amazonaws.services.groundstation.model.DeleteConfigRequest;
import com.amazonaws.services.groundstation.model.DeleteConfigResult;
import com.amazonaws.services.groundstation.model.DeleteDataflowEndpointGroupRequest;
import com.amazonaws.services.groundstation.model.DeleteDataflowEndpointGroupResult;
import com.amazonaws.services.groundstation.model.DeleteMissionProfileRequest;
import com.amazonaws.services.groundstation.model.DeleteMissionProfileResult;
import com.amazonaws.services.groundstation.model.DescribeContactRequest;
import com.amazonaws.services.groundstation.model.DescribeContactResult;
import com.amazonaws.services.groundstation.model.GetConfigRequest;
import com.amazonaws.services.groundstation.model.GetConfigResult;
import com.amazonaws.services.groundstation.model.GetDataflowEndpointGroupRequest;
import com.amazonaws.services.groundstation.model.GetDataflowEndpointGroupResult;
import com.amazonaws.services.groundstation.model.GetMinuteUsageRequest;
import com.amazonaws.services.groundstation.model.GetMinuteUsageResult;
import com.amazonaws.services.groundstation.model.GetMissionProfileRequest;
import com.amazonaws.services.groundstation.model.GetMissionProfileResult;
import com.amazonaws.services.groundstation.model.GetSatelliteRequest;
import com.amazonaws.services.groundstation.model.GetSatelliteResult;
import com.amazonaws.services.groundstation.model.ListConfigsRequest;
import com.amazonaws.services.groundstation.model.ListConfigsResult;
import com.amazonaws.services.groundstation.model.ListContactsRequest;
import com.amazonaws.services.groundstation.model.ListContactsResult;
import com.amazonaws.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import com.amazonaws.services.groundstation.model.ListDataflowEndpointGroupsResult;
import com.amazonaws.services.groundstation.model.ListGroundStationsRequest;
import com.amazonaws.services.groundstation.model.ListGroundStationsResult;
import com.amazonaws.services.groundstation.model.ListMissionProfilesRequest;
import com.amazonaws.services.groundstation.model.ListMissionProfilesResult;
import com.amazonaws.services.groundstation.model.ListSatellitesRequest;
import com.amazonaws.services.groundstation.model.ListSatellitesResult;
import com.amazonaws.services.groundstation.model.ListTagsForResourceRequest;
import com.amazonaws.services.groundstation.model.ListTagsForResourceResult;
import com.amazonaws.services.groundstation.model.ReserveContactRequest;
import com.amazonaws.services.groundstation.model.ReserveContactResult;
import com.amazonaws.services.groundstation.model.TagResourceRequest;
import com.amazonaws.services.groundstation.model.TagResourceResult;
import com.amazonaws.services.groundstation.model.UntagResourceRequest;
import com.amazonaws.services.groundstation.model.UntagResourceResult;
import com.amazonaws.services.groundstation.model.UpdateConfigRequest;
import com.amazonaws.services.groundstation.model.UpdateConfigResult;
import com.amazonaws.services.groundstation.model.UpdateMissionProfileRequest;
import com.amazonaws.services.groundstation.model.UpdateMissionProfileResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSGroundStationAsyncClient
extends AWSGroundStationClient
implements AWSGroundStationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSGroundStationAsyncClientBuilder asyncBuilder() {
        return AWSGroundStationAsyncClientBuilder.standard();
    }

    AWSGroundStationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelContactResult> cancelContactAsync(CancelContactRequest request) {
        return this.cancelContactAsync(request, null);
    }

    @Override
    public Future<CancelContactResult> cancelContactAsync(CancelContactRequest request, final AsyncHandler<CancelContactRequest, CancelContactResult> asyncHandler) {
        final CancelContactRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelContactResult>(){

            @Override
            public CancelContactResult call() throws Exception {
                CancelContactResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeCancelContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConfigResult> createConfigAsync(CreateConfigRequest request) {
        return this.createConfigAsync(request, null);
    }

    @Override
    public Future<CreateConfigResult> createConfigAsync(CreateConfigRequest request, final AsyncHandler<CreateConfigRequest, CreateConfigResult> asyncHandler) {
        final CreateConfigRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConfigResult>(){

            @Override
            public CreateConfigResult call() throws Exception {
                CreateConfigResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeCreateConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataflowEndpointGroupResult> createDataflowEndpointGroupAsync(CreateDataflowEndpointGroupRequest request) {
        return this.createDataflowEndpointGroupAsync(request, null);
    }

    @Override
    public Future<CreateDataflowEndpointGroupResult> createDataflowEndpointGroupAsync(CreateDataflowEndpointGroupRequest request, final AsyncHandler<CreateDataflowEndpointGroupRequest, CreateDataflowEndpointGroupResult> asyncHandler) {
        final CreateDataflowEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataflowEndpointGroupResult>(){

            @Override
            public CreateDataflowEndpointGroupResult call() throws Exception {
                CreateDataflowEndpointGroupResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeCreateDataflowEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMissionProfileResult> createMissionProfileAsync(CreateMissionProfileRequest request) {
        return this.createMissionProfileAsync(request, null);
    }

    @Override
    public Future<CreateMissionProfileResult> createMissionProfileAsync(CreateMissionProfileRequest request, final AsyncHandler<CreateMissionProfileRequest, CreateMissionProfileResult> asyncHandler) {
        final CreateMissionProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMissionProfileResult>(){

            @Override
            public CreateMissionProfileResult call() throws Exception {
                CreateMissionProfileResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeCreateMissionProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConfigResult> deleteConfigAsync(DeleteConfigRequest request) {
        return this.deleteConfigAsync(request, null);
    }

    @Override
    public Future<DeleteConfigResult> deleteConfigAsync(DeleteConfigRequest request, final AsyncHandler<DeleteConfigRequest, DeleteConfigResult> asyncHandler) {
        final DeleteConfigRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConfigResult>(){

            @Override
            public DeleteConfigResult call() throws Exception {
                DeleteConfigResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeDeleteConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataflowEndpointGroupResult> deleteDataflowEndpointGroupAsync(DeleteDataflowEndpointGroupRequest request) {
        return this.deleteDataflowEndpointGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDataflowEndpointGroupResult> deleteDataflowEndpointGroupAsync(DeleteDataflowEndpointGroupRequest request, final AsyncHandler<DeleteDataflowEndpointGroupRequest, DeleteDataflowEndpointGroupResult> asyncHandler) {
        final DeleteDataflowEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataflowEndpointGroupResult>(){

            @Override
            public DeleteDataflowEndpointGroupResult call() throws Exception {
                DeleteDataflowEndpointGroupResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeDeleteDataflowEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMissionProfileResult> deleteMissionProfileAsync(DeleteMissionProfileRequest request) {
        return this.deleteMissionProfileAsync(request, null);
    }

    @Override
    public Future<DeleteMissionProfileResult> deleteMissionProfileAsync(DeleteMissionProfileRequest request, final AsyncHandler<DeleteMissionProfileRequest, DeleteMissionProfileResult> asyncHandler) {
        final DeleteMissionProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMissionProfileResult>(){

            @Override
            public DeleteMissionProfileResult call() throws Exception {
                DeleteMissionProfileResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeDeleteMissionProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeContactResult> describeContactAsync(DescribeContactRequest request) {
        return this.describeContactAsync(request, null);
    }

    @Override
    public Future<DescribeContactResult> describeContactAsync(DescribeContactRequest request, final AsyncHandler<DescribeContactRequest, DescribeContactResult> asyncHandler) {
        final DescribeContactRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeContactResult>(){

            @Override
            public DescribeContactResult call() throws Exception {
                DescribeContactResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeDescribeContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConfigResult> getConfigAsync(GetConfigRequest request) {
        return this.getConfigAsync(request, null);
    }

    @Override
    public Future<GetConfigResult> getConfigAsync(GetConfigRequest request, final AsyncHandler<GetConfigRequest, GetConfigResult> asyncHandler) {
        final GetConfigRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConfigResult>(){

            @Override
            public GetConfigResult call() throws Exception {
                GetConfigResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeGetConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataflowEndpointGroupResult> getDataflowEndpointGroupAsync(GetDataflowEndpointGroupRequest request) {
        return this.getDataflowEndpointGroupAsync(request, null);
    }

    @Override
    public Future<GetDataflowEndpointGroupResult> getDataflowEndpointGroupAsync(GetDataflowEndpointGroupRequest request, final AsyncHandler<GetDataflowEndpointGroupRequest, GetDataflowEndpointGroupResult> asyncHandler) {
        final GetDataflowEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataflowEndpointGroupResult>(){

            @Override
            public GetDataflowEndpointGroupResult call() throws Exception {
                GetDataflowEndpointGroupResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeGetDataflowEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMinuteUsageResult> getMinuteUsageAsync(GetMinuteUsageRequest request) {
        return this.getMinuteUsageAsync(request, null);
    }

    @Override
    public Future<GetMinuteUsageResult> getMinuteUsageAsync(GetMinuteUsageRequest request, final AsyncHandler<GetMinuteUsageRequest, GetMinuteUsageResult> asyncHandler) {
        final GetMinuteUsageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMinuteUsageResult>(){

            @Override
            public GetMinuteUsageResult call() throws Exception {
                GetMinuteUsageResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeGetMinuteUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMissionProfileResult> getMissionProfileAsync(GetMissionProfileRequest request) {
        return this.getMissionProfileAsync(request, null);
    }

    @Override
    public Future<GetMissionProfileResult> getMissionProfileAsync(GetMissionProfileRequest request, final AsyncHandler<GetMissionProfileRequest, GetMissionProfileResult> asyncHandler) {
        final GetMissionProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMissionProfileResult>(){

            @Override
            public GetMissionProfileResult call() throws Exception {
                GetMissionProfileResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeGetMissionProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSatelliteResult> getSatelliteAsync(GetSatelliteRequest request) {
        return this.getSatelliteAsync(request, null);
    }

    @Override
    public Future<GetSatelliteResult> getSatelliteAsync(GetSatelliteRequest request, final AsyncHandler<GetSatelliteRequest, GetSatelliteResult> asyncHandler) {
        final GetSatelliteRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSatelliteResult>(){

            @Override
            public GetSatelliteResult call() throws Exception {
                GetSatelliteResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeGetSatellite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigsResult> listConfigsAsync(ListConfigsRequest request) {
        return this.listConfigsAsync(request, null);
    }

    @Override
    public Future<ListConfigsResult> listConfigsAsync(ListConfigsRequest request, final AsyncHandler<ListConfigsRequest, ListConfigsResult> asyncHandler) {
        final ListConfigsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigsResult>(){

            @Override
            public ListConfigsResult call() throws Exception {
                ListConfigsResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListConfigs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContactsResult> listContactsAsync(ListContactsRequest request) {
        return this.listContactsAsync(request, null);
    }

    @Override
    public Future<ListContactsResult> listContactsAsync(ListContactsRequest request, final AsyncHandler<ListContactsRequest, ListContactsResult> asyncHandler) {
        final ListContactsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContactsResult>(){

            @Override
            public ListContactsResult call() throws Exception {
                ListContactsResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListContacts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataflowEndpointGroupsResult> listDataflowEndpointGroupsAsync(ListDataflowEndpointGroupsRequest request) {
        return this.listDataflowEndpointGroupsAsync(request, null);
    }

    @Override
    public Future<ListDataflowEndpointGroupsResult> listDataflowEndpointGroupsAsync(ListDataflowEndpointGroupsRequest request, final AsyncHandler<ListDataflowEndpointGroupsRequest, ListDataflowEndpointGroupsResult> asyncHandler) {
        final ListDataflowEndpointGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataflowEndpointGroupsResult>(){

            @Override
            public ListDataflowEndpointGroupsResult call() throws Exception {
                ListDataflowEndpointGroupsResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListDataflowEndpointGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroundStationsResult> listGroundStationsAsync(ListGroundStationsRequest request) {
        return this.listGroundStationsAsync(request, null);
    }

    @Override
    public Future<ListGroundStationsResult> listGroundStationsAsync(ListGroundStationsRequest request, final AsyncHandler<ListGroundStationsRequest, ListGroundStationsResult> asyncHandler) {
        final ListGroundStationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroundStationsResult>(){

            @Override
            public ListGroundStationsResult call() throws Exception {
                ListGroundStationsResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListGroundStations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMissionProfilesResult> listMissionProfilesAsync(ListMissionProfilesRequest request) {
        return this.listMissionProfilesAsync(request, null);
    }

    @Override
    public Future<ListMissionProfilesResult> listMissionProfilesAsync(ListMissionProfilesRequest request, final AsyncHandler<ListMissionProfilesRequest, ListMissionProfilesResult> asyncHandler) {
        final ListMissionProfilesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMissionProfilesResult>(){

            @Override
            public ListMissionProfilesResult call() throws Exception {
                ListMissionProfilesResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListMissionProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSatellitesResult> listSatellitesAsync(ListSatellitesRequest request) {
        return this.listSatellitesAsync(request, null);
    }

    @Override
    public Future<ListSatellitesResult> listSatellitesAsync(ListSatellitesRequest request, final AsyncHandler<ListSatellitesRequest, ListSatellitesResult> asyncHandler) {
        final ListSatellitesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSatellitesResult>(){

            @Override
            public ListSatellitesResult call() throws Exception {
                ListSatellitesResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListSatellites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReserveContactResult> reserveContactAsync(ReserveContactRequest request) {
        return this.reserveContactAsync(request, null);
    }

    @Override
    public Future<ReserveContactResult> reserveContactAsync(ReserveContactRequest request, final AsyncHandler<ReserveContactRequest, ReserveContactResult> asyncHandler) {
        final ReserveContactRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReserveContactResult>(){

            @Override
            public ReserveContactResult call() throws Exception {
                ReserveContactResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeReserveContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConfigResult> updateConfigAsync(UpdateConfigRequest request) {
        return this.updateConfigAsync(request, null);
    }

    @Override
    public Future<UpdateConfigResult> updateConfigAsync(UpdateConfigRequest request, final AsyncHandler<UpdateConfigRequest, UpdateConfigResult> asyncHandler) {
        final UpdateConfigRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConfigResult>(){

            @Override
            public UpdateConfigResult call() throws Exception {
                UpdateConfigResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeUpdateConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMissionProfileResult> updateMissionProfileAsync(UpdateMissionProfileRequest request) {
        return this.updateMissionProfileAsync(request, null);
    }

    @Override
    public Future<UpdateMissionProfileResult> updateMissionProfileAsync(UpdateMissionProfileRequest request, final AsyncHandler<UpdateMissionProfileRequest, UpdateMissionProfileResult> asyncHandler) {
        final UpdateMissionProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMissionProfileResult>(){

            @Override
            public UpdateMissionProfileResult call() throws Exception {
                UpdateMissionProfileResult result = null;
                try {
                    result = AWSGroundStationAsyncClient.this.executeUpdateMissionProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

