/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.ClientAffinity;
import com.amazonaws.services.globalaccelerator.model.PortRange;
import com.amazonaws.services.globalaccelerator.model.Protocol;
import com.amazonaws.services.globalaccelerator.model.transform.ListenerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Listener
implements Serializable,
Cloneable,
StructuredPojo {
    private String listenerArn;
    private List<PortRange> portRanges;
    private String protocol;
    private String clientAffinity;

    public void setListenerArn(String listenerArn) {
        this.listenerArn = listenerArn;
    }

    public String getListenerArn() {
        return this.listenerArn;
    }

    public Listener withListenerArn(String listenerArn) {
        this.setListenerArn(listenerArn);
        return this;
    }

    public List<PortRange> getPortRanges() {
        return this.portRanges;
    }

    public void setPortRanges(Collection<PortRange> portRanges) {
        if (portRanges == null) {
            this.portRanges = null;
            return;
        }
        this.portRanges = new ArrayList<PortRange>(portRanges);
    }

    public Listener withPortRanges(PortRange ... portRanges) {
        if (this.portRanges == null) {
            this.setPortRanges(new ArrayList<PortRange>(portRanges.length));
        }
        for (PortRange ele : portRanges) {
            this.portRanges.add(ele);
        }
        return this;
    }

    public Listener withPortRanges(Collection<PortRange> portRanges) {
        this.setPortRanges(portRanges);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Listener withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public Listener withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setClientAffinity(String clientAffinity) {
        this.clientAffinity = clientAffinity;
    }

    public String getClientAffinity() {
        return this.clientAffinity;
    }

    public Listener withClientAffinity(String clientAffinity) {
        this.setClientAffinity(clientAffinity);
        return this;
    }

    public Listener withClientAffinity(ClientAffinity clientAffinity) {
        this.clientAffinity = clientAffinity.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getListenerArn() != null) {
            sb.append("ListenerArn: ").append(this.getListenerArn()).append(",");
        }
        if (this.getPortRanges() != null) {
            sb.append("PortRanges: ").append(this.getPortRanges()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getClientAffinity() != null) {
            sb.append("ClientAffinity: ").append(this.getClientAffinity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        if (other.getListenerArn() == null ^ this.getListenerArn() == null) {
            return false;
        }
        if (other.getListenerArn() != null && !other.getListenerArn().equals(this.getListenerArn())) {
            return false;
        }
        if (other.getPortRanges() == null ^ this.getPortRanges() == null) {
            return false;
        }
        if (other.getPortRanges() != null && !other.getPortRanges().equals(this.getPortRanges())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getClientAffinity() == null ^ this.getClientAffinity() == null) {
            return false;
        }
        return other.getClientAffinity() == null || other.getClientAffinity().equals(this.getClientAffinity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getListenerArn() == null ? 0 : this.getListenerArn().hashCode());
        hashCode = 31 * hashCode + (this.getPortRanges() == null ? 0 : this.getPortRanges().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getClientAffinity() == null ? 0 : this.getClientAffinity().hashCode());
        return hashCode;
    }

    public Listener clone() {
        try {
            return (Listener)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ListenerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

