/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.EndpointDescription;
import com.amazonaws.services.globalaccelerator.model.HealthCheckProtocol;
import com.amazonaws.services.globalaccelerator.model.transform.EndpointGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EndpointGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpointGroupArn;
    private String endpointGroupRegion;
    private List<EndpointDescription> endpointDescriptions;
    private Float trafficDialPercentage;
    private Integer healthCheckPort;
    private String healthCheckProtocol;
    private String healthCheckPath;
    private Integer healthCheckIntervalSeconds;
    private Integer thresholdCount;

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public EndpointGroup withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public void setEndpointGroupRegion(String endpointGroupRegion) {
        this.endpointGroupRegion = endpointGroupRegion;
    }

    public String getEndpointGroupRegion() {
        return this.endpointGroupRegion;
    }

    public EndpointGroup withEndpointGroupRegion(String endpointGroupRegion) {
        this.setEndpointGroupRegion(endpointGroupRegion);
        return this;
    }

    public List<EndpointDescription> getEndpointDescriptions() {
        return this.endpointDescriptions;
    }

    public void setEndpointDescriptions(Collection<EndpointDescription> endpointDescriptions) {
        if (endpointDescriptions == null) {
            this.endpointDescriptions = null;
            return;
        }
        this.endpointDescriptions = new ArrayList<EndpointDescription>(endpointDescriptions);
    }

    public EndpointGroup withEndpointDescriptions(EndpointDescription ... endpointDescriptions) {
        if (this.endpointDescriptions == null) {
            this.setEndpointDescriptions(new ArrayList<EndpointDescription>(endpointDescriptions.length));
        }
        for (EndpointDescription ele : endpointDescriptions) {
            this.endpointDescriptions.add(ele);
        }
        return this;
    }

    public EndpointGroup withEndpointDescriptions(Collection<EndpointDescription> endpointDescriptions) {
        this.setEndpointDescriptions(endpointDescriptions);
        return this;
    }

    public void setTrafficDialPercentage(Float trafficDialPercentage) {
        this.trafficDialPercentage = trafficDialPercentage;
    }

    public Float getTrafficDialPercentage() {
        return this.trafficDialPercentage;
    }

    public EndpointGroup withTrafficDialPercentage(Float trafficDialPercentage) {
        this.setTrafficDialPercentage(trafficDialPercentage);
        return this;
    }

    public void setHealthCheckPort(Integer healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    public Integer getHealthCheckPort() {
        return this.healthCheckPort;
    }

    public EndpointGroup withHealthCheckPort(Integer healthCheckPort) {
        this.setHealthCheckPort(healthCheckPort);
        return this;
    }

    public void setHealthCheckProtocol(String healthCheckProtocol) {
        this.healthCheckProtocol = healthCheckProtocol;
    }

    public String getHealthCheckProtocol() {
        return this.healthCheckProtocol;
    }

    public EndpointGroup withHealthCheckProtocol(String healthCheckProtocol) {
        this.setHealthCheckProtocol(healthCheckProtocol);
        return this;
    }

    public EndpointGroup withHealthCheckProtocol(HealthCheckProtocol healthCheckProtocol) {
        this.healthCheckProtocol = healthCheckProtocol.toString();
        return this;
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public EndpointGroup withHealthCheckPath(String healthCheckPath) {
        this.setHealthCheckPath(healthCheckPath);
        return this;
    }

    public void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
        this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
    }

    public Integer getHealthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public EndpointGroup withHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
        this.setHealthCheckIntervalSeconds(healthCheckIntervalSeconds);
        return this;
    }

    public void setThresholdCount(Integer thresholdCount) {
        this.thresholdCount = thresholdCount;
    }

    public Integer getThresholdCount() {
        return this.thresholdCount;
    }

    public EndpointGroup withThresholdCount(Integer thresholdCount) {
        this.setThresholdCount(thresholdCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn()).append(",");
        }
        if (this.getEndpointGroupRegion() != null) {
            sb.append("EndpointGroupRegion: ").append(this.getEndpointGroupRegion()).append(",");
        }
        if (this.getEndpointDescriptions() != null) {
            sb.append("EndpointDescriptions: ").append(this.getEndpointDescriptions()).append(",");
        }
        if (this.getTrafficDialPercentage() != null) {
            sb.append("TrafficDialPercentage: ").append(this.getTrafficDialPercentage()).append(",");
        }
        if (this.getHealthCheckPort() != null) {
            sb.append("HealthCheckPort: ").append(this.getHealthCheckPort()).append(",");
        }
        if (this.getHealthCheckProtocol() != null) {
            sb.append("HealthCheckProtocol: ").append(this.getHealthCheckProtocol()).append(",");
        }
        if (this.getHealthCheckPath() != null) {
            sb.append("HealthCheckPath: ").append(this.getHealthCheckPath()).append(",");
        }
        if (this.getHealthCheckIntervalSeconds() != null) {
            sb.append("HealthCheckIntervalSeconds: ").append(this.getHealthCheckIntervalSeconds()).append(",");
        }
        if (this.getThresholdCount() != null) {
            sb.append("ThresholdCount: ").append(this.getThresholdCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointGroup)) {
            return false;
        }
        EndpointGroup other = (EndpointGroup)obj;
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        if (other.getEndpointGroupArn() != null && !other.getEndpointGroupArn().equals(this.getEndpointGroupArn())) {
            return false;
        }
        if (other.getEndpointGroupRegion() == null ^ this.getEndpointGroupRegion() == null) {
            return false;
        }
        if (other.getEndpointGroupRegion() != null && !other.getEndpointGroupRegion().equals(this.getEndpointGroupRegion())) {
            return false;
        }
        if (other.getEndpointDescriptions() == null ^ this.getEndpointDescriptions() == null) {
            return false;
        }
        if (other.getEndpointDescriptions() != null && !other.getEndpointDescriptions().equals(this.getEndpointDescriptions())) {
            return false;
        }
        if (other.getTrafficDialPercentage() == null ^ this.getTrafficDialPercentage() == null) {
            return false;
        }
        if (other.getTrafficDialPercentage() != null && !other.getTrafficDialPercentage().equals(this.getTrafficDialPercentage())) {
            return false;
        }
        if (other.getHealthCheckPort() == null ^ this.getHealthCheckPort() == null) {
            return false;
        }
        if (other.getHealthCheckPort() != null && !other.getHealthCheckPort().equals(this.getHealthCheckPort())) {
            return false;
        }
        if (other.getHealthCheckProtocol() == null ^ this.getHealthCheckProtocol() == null) {
            return false;
        }
        if (other.getHealthCheckProtocol() != null && !other.getHealthCheckProtocol().equals(this.getHealthCheckProtocol())) {
            return false;
        }
        if (other.getHealthCheckPath() == null ^ this.getHealthCheckPath() == null) {
            return false;
        }
        if (other.getHealthCheckPath() != null && !other.getHealthCheckPath().equals(this.getHealthCheckPath())) {
            return false;
        }
        if (other.getHealthCheckIntervalSeconds() == null ^ this.getHealthCheckIntervalSeconds() == null) {
            return false;
        }
        if (other.getHealthCheckIntervalSeconds() != null && !other.getHealthCheckIntervalSeconds().equals(this.getHealthCheckIntervalSeconds())) {
            return false;
        }
        if (other.getThresholdCount() == null ^ this.getThresholdCount() == null) {
            return false;
        }
        return other.getThresholdCount() == null || other.getThresholdCount().equals(this.getThresholdCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointGroupRegion() == null ? 0 : this.getEndpointGroupRegion().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointDescriptions() == null ? 0 : this.getEndpointDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficDialPercentage() == null ? 0 : this.getTrafficDialPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckPort() == null ? 0 : this.getHealthCheckPort().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckProtocol() == null ? 0 : this.getHealthCheckProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckPath() == null ? 0 : this.getHealthCheckPath().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckIntervalSeconds() == null ? 0 : this.getHealthCheckIntervalSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getThresholdCount() == null ? 0 : this.getThresholdCount().hashCode());
        return hashCode;
    }

    public EndpointGroup clone() {
        try {
            return (EndpointGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

