/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.globalaccelerator.AWSGlobalAcceleratorAsync;
import com.amazonaws.services.globalaccelerator.AWSGlobalAcceleratorAsyncClientBuilder;
import com.amazonaws.services.globalaccelerator.AWSGlobalAcceleratorClient;
import com.amazonaws.services.globalaccelerator.model.CreateAcceleratorRequest;
import com.amazonaws.services.globalaccelerator.model.CreateAcceleratorResult;
import com.amazonaws.services.globalaccelerator.model.CreateEndpointGroupRequest;
import com.amazonaws.services.globalaccelerator.model.CreateEndpointGroupResult;
import com.amazonaws.services.globalaccelerator.model.CreateListenerRequest;
import com.amazonaws.services.globalaccelerator.model.CreateListenerResult;
import com.amazonaws.services.globalaccelerator.model.DeleteAcceleratorRequest;
import com.amazonaws.services.globalaccelerator.model.DeleteAcceleratorResult;
import com.amazonaws.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import com.amazonaws.services.globalaccelerator.model.DeleteEndpointGroupResult;
import com.amazonaws.services.globalaccelerator.model.DeleteListenerRequest;
import com.amazonaws.services.globalaccelerator.model.DeleteListenerResult;
import com.amazonaws.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import com.amazonaws.services.globalaccelerator.model.DescribeAcceleratorAttributesResult;
import com.amazonaws.services.globalaccelerator.model.DescribeAcceleratorRequest;
import com.amazonaws.services.globalaccelerator.model.DescribeAcceleratorResult;
import com.amazonaws.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import com.amazonaws.services.globalaccelerator.model.DescribeEndpointGroupResult;
import com.amazonaws.services.globalaccelerator.model.DescribeListenerRequest;
import com.amazonaws.services.globalaccelerator.model.DescribeListenerResult;
import com.amazonaws.services.globalaccelerator.model.ListAcceleratorsRequest;
import com.amazonaws.services.globalaccelerator.model.ListAcceleratorsResult;
import com.amazonaws.services.globalaccelerator.model.ListEndpointGroupsRequest;
import com.amazonaws.services.globalaccelerator.model.ListEndpointGroupsResult;
import com.amazonaws.services.globalaccelerator.model.ListListenersRequest;
import com.amazonaws.services.globalaccelerator.model.ListListenersResult;
import com.amazonaws.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import com.amazonaws.services.globalaccelerator.model.UpdateAcceleratorAttributesResult;
import com.amazonaws.services.globalaccelerator.model.UpdateAcceleratorRequest;
import com.amazonaws.services.globalaccelerator.model.UpdateAcceleratorResult;
import com.amazonaws.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import com.amazonaws.services.globalaccelerator.model.UpdateEndpointGroupResult;
import com.amazonaws.services.globalaccelerator.model.UpdateListenerRequest;
import com.amazonaws.services.globalaccelerator.model.UpdateListenerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSGlobalAcceleratorAsyncClient
extends AWSGlobalAcceleratorClient
implements AWSGlobalAcceleratorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSGlobalAcceleratorAsyncClientBuilder asyncBuilder() {
        return AWSGlobalAcceleratorAsyncClientBuilder.standard();
    }

    AWSGlobalAcceleratorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAcceleratorResult> createAcceleratorAsync(CreateAcceleratorRequest request) {
        return this.createAcceleratorAsync(request, null);
    }

    @Override
    public Future<CreateAcceleratorResult> createAcceleratorAsync(CreateAcceleratorRequest request, final AsyncHandler<CreateAcceleratorRequest, CreateAcceleratorResult> asyncHandler) {
        final CreateAcceleratorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAcceleratorResult>(){

            @Override
            public CreateAcceleratorResult call() throws Exception {
                CreateAcceleratorResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeCreateAccelerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEndpointGroupResult> createEndpointGroupAsync(CreateEndpointGroupRequest request) {
        return this.createEndpointGroupAsync(request, null);
    }

    @Override
    public Future<CreateEndpointGroupResult> createEndpointGroupAsync(CreateEndpointGroupRequest request, final AsyncHandler<CreateEndpointGroupRequest, CreateEndpointGroupResult> asyncHandler) {
        final CreateEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEndpointGroupResult>(){

            @Override
            public CreateEndpointGroupResult call() throws Exception {
                CreateEndpointGroupResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeCreateEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateListenerResult> createListenerAsync(CreateListenerRequest request) {
        return this.createListenerAsync(request, null);
    }

    @Override
    public Future<CreateListenerResult> createListenerAsync(CreateListenerRequest request, final AsyncHandler<CreateListenerRequest, CreateListenerResult> asyncHandler) {
        final CreateListenerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateListenerResult>(){

            @Override
            public CreateListenerResult call() throws Exception {
                CreateListenerResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeCreateListener(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAcceleratorResult> deleteAcceleratorAsync(DeleteAcceleratorRequest request) {
        return this.deleteAcceleratorAsync(request, null);
    }

    @Override
    public Future<DeleteAcceleratorResult> deleteAcceleratorAsync(DeleteAcceleratorRequest request, final AsyncHandler<DeleteAcceleratorRequest, DeleteAcceleratorResult> asyncHandler) {
        final DeleteAcceleratorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAcceleratorResult>(){

            @Override
            public DeleteAcceleratorResult call() throws Exception {
                DeleteAcceleratorResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDeleteAccelerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEndpointGroupResult> deleteEndpointGroupAsync(DeleteEndpointGroupRequest request) {
        return this.deleteEndpointGroupAsync(request, null);
    }

    @Override
    public Future<DeleteEndpointGroupResult> deleteEndpointGroupAsync(DeleteEndpointGroupRequest request, final AsyncHandler<DeleteEndpointGroupRequest, DeleteEndpointGroupResult> asyncHandler) {
        final DeleteEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEndpointGroupResult>(){

            @Override
            public DeleteEndpointGroupResult call() throws Exception {
                DeleteEndpointGroupResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDeleteEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteListenerResult> deleteListenerAsync(DeleteListenerRequest request) {
        return this.deleteListenerAsync(request, null);
    }

    @Override
    public Future<DeleteListenerResult> deleteListenerAsync(DeleteListenerRequest request, final AsyncHandler<DeleteListenerRequest, DeleteListenerResult> asyncHandler) {
        final DeleteListenerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteListenerResult>(){

            @Override
            public DeleteListenerResult call() throws Exception {
                DeleteListenerResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDeleteListener(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAcceleratorResult> describeAcceleratorAsync(DescribeAcceleratorRequest request) {
        return this.describeAcceleratorAsync(request, null);
    }

    @Override
    public Future<DescribeAcceleratorResult> describeAcceleratorAsync(DescribeAcceleratorRequest request, final AsyncHandler<DescribeAcceleratorRequest, DescribeAcceleratorResult> asyncHandler) {
        final DescribeAcceleratorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAcceleratorResult>(){

            @Override
            public DescribeAcceleratorResult call() throws Exception {
                DescribeAcceleratorResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDescribeAccelerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAcceleratorAttributesResult> describeAcceleratorAttributesAsync(DescribeAcceleratorAttributesRequest request) {
        return this.describeAcceleratorAttributesAsync(request, null);
    }

    @Override
    public Future<DescribeAcceleratorAttributesResult> describeAcceleratorAttributesAsync(DescribeAcceleratorAttributesRequest request, final AsyncHandler<DescribeAcceleratorAttributesRequest, DescribeAcceleratorAttributesResult> asyncHandler) {
        final DescribeAcceleratorAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAcceleratorAttributesResult>(){

            @Override
            public DescribeAcceleratorAttributesResult call() throws Exception {
                DescribeAcceleratorAttributesResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDescribeAcceleratorAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointGroupResult> describeEndpointGroupAsync(DescribeEndpointGroupRequest request) {
        return this.describeEndpointGroupAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointGroupResult> describeEndpointGroupAsync(DescribeEndpointGroupRequest request, final AsyncHandler<DescribeEndpointGroupRequest, DescribeEndpointGroupResult> asyncHandler) {
        final DescribeEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointGroupResult>(){

            @Override
            public DescribeEndpointGroupResult call() throws Exception {
                DescribeEndpointGroupResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDescribeEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeListenerResult> describeListenerAsync(DescribeListenerRequest request) {
        return this.describeListenerAsync(request, null);
    }

    @Override
    public Future<DescribeListenerResult> describeListenerAsync(DescribeListenerRequest request, final AsyncHandler<DescribeListenerRequest, DescribeListenerResult> asyncHandler) {
        final DescribeListenerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeListenerResult>(){

            @Override
            public DescribeListenerResult call() throws Exception {
                DescribeListenerResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeDescribeListener(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAcceleratorsResult> listAcceleratorsAsync(ListAcceleratorsRequest request) {
        return this.listAcceleratorsAsync(request, null);
    }

    @Override
    public Future<ListAcceleratorsResult> listAcceleratorsAsync(ListAcceleratorsRequest request, final AsyncHandler<ListAcceleratorsRequest, ListAcceleratorsResult> asyncHandler) {
        final ListAcceleratorsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAcceleratorsResult>(){

            @Override
            public ListAcceleratorsResult call() throws Exception {
                ListAcceleratorsResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeListAccelerators(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEndpointGroupsResult> listEndpointGroupsAsync(ListEndpointGroupsRequest request) {
        return this.listEndpointGroupsAsync(request, null);
    }

    @Override
    public Future<ListEndpointGroupsResult> listEndpointGroupsAsync(ListEndpointGroupsRequest request, final AsyncHandler<ListEndpointGroupsRequest, ListEndpointGroupsResult> asyncHandler) {
        final ListEndpointGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEndpointGroupsResult>(){

            @Override
            public ListEndpointGroupsResult call() throws Exception {
                ListEndpointGroupsResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeListEndpointGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListListenersResult> listListenersAsync(ListListenersRequest request) {
        return this.listListenersAsync(request, null);
    }

    @Override
    public Future<ListListenersResult> listListenersAsync(ListListenersRequest request, final AsyncHandler<ListListenersRequest, ListListenersResult> asyncHandler) {
        final ListListenersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListListenersResult>(){

            @Override
            public ListListenersResult call() throws Exception {
                ListListenersResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeListListeners(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAcceleratorResult> updateAcceleratorAsync(UpdateAcceleratorRequest request) {
        return this.updateAcceleratorAsync(request, null);
    }

    @Override
    public Future<UpdateAcceleratorResult> updateAcceleratorAsync(UpdateAcceleratorRequest request, final AsyncHandler<UpdateAcceleratorRequest, UpdateAcceleratorResult> asyncHandler) {
        final UpdateAcceleratorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAcceleratorResult>(){

            @Override
            public UpdateAcceleratorResult call() throws Exception {
                UpdateAcceleratorResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeUpdateAccelerator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAcceleratorAttributesResult> updateAcceleratorAttributesAsync(UpdateAcceleratorAttributesRequest request) {
        return this.updateAcceleratorAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateAcceleratorAttributesResult> updateAcceleratorAttributesAsync(UpdateAcceleratorAttributesRequest request, final AsyncHandler<UpdateAcceleratorAttributesRequest, UpdateAcceleratorAttributesResult> asyncHandler) {
        final UpdateAcceleratorAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAcceleratorAttributesResult>(){

            @Override
            public UpdateAcceleratorAttributesResult call() throws Exception {
                UpdateAcceleratorAttributesResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeUpdateAcceleratorAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEndpointGroupResult> updateEndpointGroupAsync(UpdateEndpointGroupRequest request) {
        return this.updateEndpointGroupAsync(request, null);
    }

    @Override
    public Future<UpdateEndpointGroupResult> updateEndpointGroupAsync(UpdateEndpointGroupRequest request, final AsyncHandler<UpdateEndpointGroupRequest, UpdateEndpointGroupResult> asyncHandler) {
        final UpdateEndpointGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEndpointGroupResult>(){

            @Override
            public UpdateEndpointGroupResult call() throws Exception {
                UpdateEndpointGroupResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeUpdateEndpointGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateListenerResult> updateListenerAsync(UpdateListenerRequest request) {
        return this.updateListenerAsync(request, null);
    }

    @Override
    public Future<UpdateListenerResult> updateListenerAsync(UpdateListenerRequest request, final AsyncHandler<UpdateListenerRequest, UpdateListenerResult> asyncHandler) {
        final UpdateListenerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateListenerResult>(){

            @Override
            public UpdateListenerResult call() throws Exception {
                UpdateListenerResult result = null;
                try {
                    result = AWSGlobalAcceleratorAsyncClient.this.executeUpdateListener(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

