/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.services.fsx.model.FileSystem;
import com.amazonaws.services.fsx.model.Tag;
import com.amazonaws.services.fsx.model.transform.FileSystemFailureDetailsJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.LustreFileSystemConfigurationJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.TagJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.WindowsFileSystemConfigurationJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;

public class FileSystemJsonUnmarshaller
implements Unmarshaller<FileSystem, JsonUnmarshallerContext> {
    private static FileSystemJsonUnmarshaller instance;

    @Override
    public FileSystem unmarshall(JsonUnmarshallerContext context) throws Exception {
        FileSystem fileSystem = new FileSystem();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OwnerId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setOwnerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    fileSystem.setCreationTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("FileSystemId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setFileSystemId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FileSystemType", targetDepth)) {
                    context.nextToken();
                    fileSystem.setFileSystemType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Lifecycle", targetDepth)) {
                    context.nextToken();
                    fileSystem.setLifecycle(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FailureDetails", targetDepth)) {
                    context.nextToken();
                    fileSystem.setFailureDetails(FileSystemFailureDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StorageCapacity", targetDepth)) {
                    context.nextToken();
                    fileSystem.setStorageCapacity(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setVpcId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SubnetIds", targetDepth)) {
                    context.nextToken();
                    fileSystem.setSubnetIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("NetworkInterfaceIds", targetDepth)) {
                    context.nextToken();
                    fileSystem.setNetworkInterfaceIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("DNSName", targetDepth)) {
                    context.nextToken();
                    fileSystem.setDNSName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setKmsKeyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResourceARN", targetDepth)) {
                    context.nextToken();
                    fileSystem.setResourceARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    fileSystem.setTags(new ListUnmarshaller<Tag>(TagJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("WindowsConfiguration", targetDepth)) {
                    context.nextToken();
                    fileSystem.setWindowsConfiguration(WindowsFileSystemConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LustreConfiguration", targetDepth)) {
                    context.nextToken();
                    fileSystem.setLustreConfiguration(LustreFileSystemConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return fileSystem;
    }

    public static FileSystemJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FileSystemJsonUnmarshaller();
        }
        return instance;
    }
}

