/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.FileSystemMaintenanceOperation;
import com.amazonaws.services.fsx.model.SelfManagedActiveDirectoryAttributes;
import com.amazonaws.services.fsx.model.WindowsDeploymentType;
import com.amazonaws.services.fsx.model.transform.WindowsFileSystemConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WindowsFileSystemConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String activeDirectoryId;
    private SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration;
    private String deploymentType;
    private String remoteAdministrationEndpoint;
    private String preferredSubnetId;
    private String preferredFileServerIp;
    private Integer throughputCapacity;
    private List<String> maintenanceOperationsInProgress;
    private String weeklyMaintenanceStartTime;
    private String dailyAutomaticBackupStartTime;
    private Integer automaticBackupRetentionDays;
    private Boolean copyTagsToBackups;

    public void setActiveDirectoryId(String activeDirectoryId) {
        this.activeDirectoryId = activeDirectoryId;
    }

    public String getActiveDirectoryId() {
        return this.activeDirectoryId;
    }

    public WindowsFileSystemConfiguration withActiveDirectoryId(String activeDirectoryId) {
        this.setActiveDirectoryId(activeDirectoryId);
        return this;
    }

    public void setSelfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration) {
        this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
    }

    public SelfManagedActiveDirectoryAttributes getSelfManagedActiveDirectoryConfiguration() {
        return this.selfManagedActiveDirectoryConfiguration;
    }

    public WindowsFileSystemConfiguration withSelfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryAttributes selfManagedActiveDirectoryConfiguration) {
        this.setSelfManagedActiveDirectoryConfiguration(selfManagedActiveDirectoryConfiguration);
        return this;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public WindowsFileSystemConfiguration withDeploymentType(String deploymentType) {
        this.setDeploymentType(deploymentType);
        return this;
    }

    public WindowsFileSystemConfiguration withDeploymentType(WindowsDeploymentType deploymentType) {
        this.deploymentType = deploymentType.toString();
        return this;
    }

    public void setRemoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
        this.remoteAdministrationEndpoint = remoteAdministrationEndpoint;
    }

    public String getRemoteAdministrationEndpoint() {
        return this.remoteAdministrationEndpoint;
    }

    public WindowsFileSystemConfiguration withRemoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
        this.setRemoteAdministrationEndpoint(remoteAdministrationEndpoint);
        return this;
    }

    public void setPreferredSubnetId(String preferredSubnetId) {
        this.preferredSubnetId = preferredSubnetId;
    }

    public String getPreferredSubnetId() {
        return this.preferredSubnetId;
    }

    public WindowsFileSystemConfiguration withPreferredSubnetId(String preferredSubnetId) {
        this.setPreferredSubnetId(preferredSubnetId);
        return this;
    }

    public void setPreferredFileServerIp(String preferredFileServerIp) {
        this.preferredFileServerIp = preferredFileServerIp;
    }

    public String getPreferredFileServerIp() {
        return this.preferredFileServerIp;
    }

    public WindowsFileSystemConfiguration withPreferredFileServerIp(String preferredFileServerIp) {
        this.setPreferredFileServerIp(preferredFileServerIp);
        return this;
    }

    public void setThroughputCapacity(Integer throughputCapacity) {
        this.throughputCapacity = throughputCapacity;
    }

    public Integer getThroughputCapacity() {
        return this.throughputCapacity;
    }

    public WindowsFileSystemConfiguration withThroughputCapacity(Integer throughputCapacity) {
        this.setThroughputCapacity(throughputCapacity);
        return this;
    }

    public List<String> getMaintenanceOperationsInProgress() {
        return this.maintenanceOperationsInProgress;
    }

    public void setMaintenanceOperationsInProgress(Collection<String> maintenanceOperationsInProgress) {
        if (maintenanceOperationsInProgress == null) {
            this.maintenanceOperationsInProgress = null;
            return;
        }
        this.maintenanceOperationsInProgress = new ArrayList<String>(maintenanceOperationsInProgress);
    }

    public WindowsFileSystemConfiguration withMaintenanceOperationsInProgress(String ... maintenanceOperationsInProgress) {
        if (this.maintenanceOperationsInProgress == null) {
            this.setMaintenanceOperationsInProgress(new ArrayList<String>(maintenanceOperationsInProgress.length));
        }
        for (String ele : maintenanceOperationsInProgress) {
            this.maintenanceOperationsInProgress.add(ele);
        }
        return this;
    }

    public WindowsFileSystemConfiguration withMaintenanceOperationsInProgress(Collection<String> maintenanceOperationsInProgress) {
        this.setMaintenanceOperationsInProgress(maintenanceOperationsInProgress);
        return this;
    }

    public WindowsFileSystemConfiguration withMaintenanceOperationsInProgress(FileSystemMaintenanceOperation ... maintenanceOperationsInProgress) {
        ArrayList<String> maintenanceOperationsInProgressCopy = new ArrayList<String>(maintenanceOperationsInProgress.length);
        for (FileSystemMaintenanceOperation value : maintenanceOperationsInProgress) {
            maintenanceOperationsInProgressCopy.add(value.toString());
        }
        if (this.getMaintenanceOperationsInProgress() == null) {
            this.setMaintenanceOperationsInProgress(maintenanceOperationsInProgressCopy);
        } else {
            this.getMaintenanceOperationsInProgress().addAll(maintenanceOperationsInProgressCopy);
        }
        return this;
    }

    public void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
        this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
    }

    public String getWeeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public WindowsFileSystemConfiguration withWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
        this.setWeeklyMaintenanceStartTime(weeklyMaintenanceStartTime);
        return this;
    }

    public void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
        this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
    }

    public String getDailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public WindowsFileSystemConfiguration withDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
        this.setDailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime);
        return this;
    }

    public void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
        this.automaticBackupRetentionDays = automaticBackupRetentionDays;
    }

    public Integer getAutomaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public WindowsFileSystemConfiguration withAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
        this.setAutomaticBackupRetentionDays(automaticBackupRetentionDays);
        return this;
    }

    public void setCopyTagsToBackups(Boolean copyTagsToBackups) {
        this.copyTagsToBackups = copyTagsToBackups;
    }

    public Boolean getCopyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public WindowsFileSystemConfiguration withCopyTagsToBackups(Boolean copyTagsToBackups) {
        this.setCopyTagsToBackups(copyTagsToBackups);
        return this;
    }

    public Boolean isCopyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActiveDirectoryId() != null) {
            sb.append("ActiveDirectoryId: ").append(this.getActiveDirectoryId()).append(",");
        }
        if (this.getSelfManagedActiveDirectoryConfiguration() != null) {
            sb.append("SelfManagedActiveDirectoryConfiguration: ").append(this.getSelfManagedActiveDirectoryConfiguration()).append(",");
        }
        if (this.getDeploymentType() != null) {
            sb.append("DeploymentType: ").append(this.getDeploymentType()).append(",");
        }
        if (this.getRemoteAdministrationEndpoint() != null) {
            sb.append("RemoteAdministrationEndpoint: ").append(this.getRemoteAdministrationEndpoint()).append(",");
        }
        if (this.getPreferredSubnetId() != null) {
            sb.append("PreferredSubnetId: ").append(this.getPreferredSubnetId()).append(",");
        }
        if (this.getPreferredFileServerIp() != null) {
            sb.append("PreferredFileServerIp: ").append(this.getPreferredFileServerIp()).append(",");
        }
        if (this.getThroughputCapacity() != null) {
            sb.append("ThroughputCapacity: ").append(this.getThroughputCapacity()).append(",");
        }
        if (this.getMaintenanceOperationsInProgress() != null) {
            sb.append("MaintenanceOperationsInProgress: ").append(this.getMaintenanceOperationsInProgress()).append(",");
        }
        if (this.getWeeklyMaintenanceStartTime() != null) {
            sb.append("WeeklyMaintenanceStartTime: ").append(this.getWeeklyMaintenanceStartTime()).append(",");
        }
        if (this.getDailyAutomaticBackupStartTime() != null) {
            sb.append("DailyAutomaticBackupStartTime: ").append(this.getDailyAutomaticBackupStartTime()).append(",");
        }
        if (this.getAutomaticBackupRetentionDays() != null) {
            sb.append("AutomaticBackupRetentionDays: ").append(this.getAutomaticBackupRetentionDays()).append(",");
        }
        if (this.getCopyTagsToBackups() != null) {
            sb.append("CopyTagsToBackups: ").append(this.getCopyTagsToBackups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsFileSystemConfiguration)) {
            return false;
        }
        WindowsFileSystemConfiguration other = (WindowsFileSystemConfiguration)obj;
        if (other.getActiveDirectoryId() == null ^ this.getActiveDirectoryId() == null) {
            return false;
        }
        if (other.getActiveDirectoryId() != null && !other.getActiveDirectoryId().equals(this.getActiveDirectoryId())) {
            return false;
        }
        if (other.getSelfManagedActiveDirectoryConfiguration() == null ^ this.getSelfManagedActiveDirectoryConfiguration() == null) {
            return false;
        }
        if (other.getSelfManagedActiveDirectoryConfiguration() != null && !other.getSelfManagedActiveDirectoryConfiguration().equals(this.getSelfManagedActiveDirectoryConfiguration())) {
            return false;
        }
        if (other.getDeploymentType() == null ^ this.getDeploymentType() == null) {
            return false;
        }
        if (other.getDeploymentType() != null && !other.getDeploymentType().equals(this.getDeploymentType())) {
            return false;
        }
        if (other.getRemoteAdministrationEndpoint() == null ^ this.getRemoteAdministrationEndpoint() == null) {
            return false;
        }
        if (other.getRemoteAdministrationEndpoint() != null && !other.getRemoteAdministrationEndpoint().equals(this.getRemoteAdministrationEndpoint())) {
            return false;
        }
        if (other.getPreferredSubnetId() == null ^ this.getPreferredSubnetId() == null) {
            return false;
        }
        if (other.getPreferredSubnetId() != null && !other.getPreferredSubnetId().equals(this.getPreferredSubnetId())) {
            return false;
        }
        if (other.getPreferredFileServerIp() == null ^ this.getPreferredFileServerIp() == null) {
            return false;
        }
        if (other.getPreferredFileServerIp() != null && !other.getPreferredFileServerIp().equals(this.getPreferredFileServerIp())) {
            return false;
        }
        if (other.getThroughputCapacity() == null ^ this.getThroughputCapacity() == null) {
            return false;
        }
        if (other.getThroughputCapacity() != null && !other.getThroughputCapacity().equals(this.getThroughputCapacity())) {
            return false;
        }
        if (other.getMaintenanceOperationsInProgress() == null ^ this.getMaintenanceOperationsInProgress() == null) {
            return false;
        }
        if (other.getMaintenanceOperationsInProgress() != null && !other.getMaintenanceOperationsInProgress().equals(this.getMaintenanceOperationsInProgress())) {
            return false;
        }
        if (other.getWeeklyMaintenanceStartTime() == null ^ this.getWeeklyMaintenanceStartTime() == null) {
            return false;
        }
        if (other.getWeeklyMaintenanceStartTime() != null && !other.getWeeklyMaintenanceStartTime().equals(this.getWeeklyMaintenanceStartTime())) {
            return false;
        }
        if (other.getDailyAutomaticBackupStartTime() == null ^ this.getDailyAutomaticBackupStartTime() == null) {
            return false;
        }
        if (other.getDailyAutomaticBackupStartTime() != null && !other.getDailyAutomaticBackupStartTime().equals(this.getDailyAutomaticBackupStartTime())) {
            return false;
        }
        if (other.getAutomaticBackupRetentionDays() == null ^ this.getAutomaticBackupRetentionDays() == null) {
            return false;
        }
        if (other.getAutomaticBackupRetentionDays() != null && !other.getAutomaticBackupRetentionDays().equals(this.getAutomaticBackupRetentionDays())) {
            return false;
        }
        if (other.getCopyTagsToBackups() == null ^ this.getCopyTagsToBackups() == null) {
            return false;
        }
        return other.getCopyTagsToBackups() == null || other.getCopyTagsToBackups().equals(this.getCopyTagsToBackups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActiveDirectoryId() == null ? 0 : this.getActiveDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getSelfManagedActiveDirectoryConfiguration() == null ? 0 : this.getSelfManagedActiveDirectoryConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentType() == null ? 0 : this.getDeploymentType().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteAdministrationEndpoint() == null ? 0 : this.getRemoteAdministrationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredSubnetId() == null ? 0 : this.getPreferredSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredFileServerIp() == null ? 0 : this.getPreferredFileServerIp().hashCode());
        hashCode = 31 * hashCode + (this.getThroughputCapacity() == null ? 0 : this.getThroughputCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceOperationsInProgress() == null ? 0 : this.getMaintenanceOperationsInProgress().hashCode());
        hashCode = 31 * hashCode + (this.getWeeklyMaintenanceStartTime() == null ? 0 : this.getWeeklyMaintenanceStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getDailyAutomaticBackupStartTime() == null ? 0 : this.getDailyAutomaticBackupStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticBackupRetentionDays() == null ? 0 : this.getAutomaticBackupRetentionDays().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToBackups() == null ? 0 : this.getCopyTagsToBackups().hashCode());
        return hashCode;
    }

    public WindowsFileSystemConfiguration clone() {
        try {
            return (WindowsFileSystemConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WindowsFileSystemConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

