/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.WindowSummary;
import java.util.Date;

@SdkInternalApi
public class WindowSummaryMarshaller {
    private static final MarshallingInfo<Date> TESTWINDOWSTART_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TestWindowStart").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> TESTWINDOWEND_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TestWindowEnd").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> ITEMCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").build();
    private static final MarshallingInfo<String> EVALUATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationType").build();
    private static final MarshallingInfo<StructuredPojo> METRICS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metrics").build();
    private static final WindowSummaryMarshaller instance = new WindowSummaryMarshaller();

    public static WindowSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(WindowSummary windowSummary, ProtocolMarshaller protocolMarshaller) {
        if (windowSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(windowSummary.getTestWindowStart(), TESTWINDOWSTART_BINDING);
            protocolMarshaller.marshall(windowSummary.getTestWindowEnd(), TESTWINDOWEND_BINDING);
            protocolMarshaller.marshall(windowSummary.getItemCount(), ITEMCOUNT_BINDING);
            protocolMarshaller.marshall(windowSummary.getEvaluationType(), EVALUATIONTYPE_BINDING);
            protocolMarshaller.marshall(windowSummary.getMetrics(), METRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

