/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.WeightedQuantileLoss;

@SdkInternalApi
public class WeightedQuantileLossMarshaller {
    private static final MarshallingInfo<Double> QUANTILE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quantile").build();
    private static final MarshallingInfo<Double> LOSSVALUE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LossValue").build();
    private static final WeightedQuantileLossMarshaller instance = new WeightedQuantileLossMarshaller();

    public static WeightedQuantileLossMarshaller getInstance() {
        return instance;
    }

    public void marshall(WeightedQuantileLoss weightedQuantileLoss, ProtocolMarshaller protocolMarshaller) {
        if (weightedQuantileLoss == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(weightedQuantileLoss.getQuantile(), QUANTILE_BINDING);
            protocolMarshaller.marshall(weightedQuantileLoss.getLossValue(), LOSSVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

