/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.services.forecast.model.Schema;
import com.amazonaws.services.forecast.model.SchemaAttribute;
import com.amazonaws.services.forecast.model.transform.SchemaAttributeJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class SchemaJsonUnmarshaller
implements Unmarshaller<Schema, JsonUnmarshallerContext> {
    private static SchemaJsonUnmarshaller instance;

    @Override
    public Schema unmarshall(JsonUnmarshallerContext context) throws Exception {
        Schema schema = new Schema();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    schema.setAttributes(new ListUnmarshaller<SchemaAttribute>(SchemaAttributeJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return schema;
    }

    public static SchemaJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SchemaJsonUnmarshaller();
        }
        return instance;
    }
}

