/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.SchemaAttribute;

@SdkInternalApi
public class SchemaAttributeMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").build();
    private static final MarshallingInfo<String> ATTRIBUTETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeType").build();
    private static final SchemaAttributeMarshaller instance = new SchemaAttributeMarshaller();

    public static SchemaAttributeMarshaller getInstance() {
        return instance;
    }

    public void marshall(SchemaAttribute schemaAttribute, ProtocolMarshaller protocolMarshaller) {
        if (schemaAttribute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(schemaAttribute.getAttributeName(), ATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall(schemaAttribute.getAttributeType(), ATTRIBUTETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

