/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.services.forecast.model.Metrics;
import com.amazonaws.services.forecast.model.WeightedQuantileLoss;
import com.amazonaws.services.forecast.model.transform.WeightedQuantileLossJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class MetricsJsonUnmarshaller
implements Unmarshaller<Metrics, JsonUnmarshallerContext> {
    private static MetricsJsonUnmarshaller instance;

    @Override
    public Metrics unmarshall(JsonUnmarshallerContext context) throws Exception {
        Metrics metrics = new Metrics();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RMSE", targetDepth)) {
                    context.nextToken();
                    metrics.setRMSE(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("WeightedQuantileLosses", targetDepth)) {
                    context.nextToken();
                    metrics.setWeightedQuantileLosses(new ListUnmarshaller<WeightedQuantileLoss>(WeightedQuantileLossJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return metrics;
    }

    public static MetricsJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricsJsonUnmarshaller();
        }
        return instance;
    }
}

