/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.transform.S3ConfigMarshaller;
import java.io.Serializable;

public class S3Config
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private String roleArn;
    private String kMSKeyArn;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public S3Config withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public S3Config withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setKMSKeyArn(String kMSKeyArn) {
        this.kMSKeyArn = kMSKeyArn;
    }

    public String getKMSKeyArn() {
        return this.kMSKeyArn;
    }

    public S3Config withKMSKeyArn(String kMSKeyArn) {
        this.setKMSKeyArn(kMSKeyArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getKMSKeyArn() != null) {
            sb.append("KMSKeyArn: ").append(this.getKMSKeyArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getKMSKeyArn() == null ^ this.getKMSKeyArn() == null) {
            return false;
        }
        return other.getKMSKeyArn() == null || other.getKMSKeyArn().equals(this.getKMSKeyArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyArn() == null ? 0 : this.getKMSKeyArn().hashCode());
        return hashCode;
    }

    public S3Config clone() {
        try {
            return (S3Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

