/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.WindowSummary;
import com.amazonaws.services.forecast.model.transform.EvaluationResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EvaluationResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithmArn;
    private List<WindowSummary> testWindows;

    public void setAlgorithmArn(String algorithmArn) {
        this.algorithmArn = algorithmArn;
    }

    public String getAlgorithmArn() {
        return this.algorithmArn;
    }

    public EvaluationResult withAlgorithmArn(String algorithmArn) {
        this.setAlgorithmArn(algorithmArn);
        return this;
    }

    public List<WindowSummary> getTestWindows() {
        return this.testWindows;
    }

    public void setTestWindows(Collection<WindowSummary> testWindows) {
        if (testWindows == null) {
            this.testWindows = null;
            return;
        }
        this.testWindows = new ArrayList<WindowSummary>(testWindows);
    }

    public EvaluationResult withTestWindows(WindowSummary ... testWindows) {
        if (this.testWindows == null) {
            this.setTestWindows(new ArrayList<WindowSummary>(testWindows.length));
        }
        for (WindowSummary ele : testWindows) {
            this.testWindows.add(ele);
        }
        return this;
    }

    public EvaluationResult withTestWindows(Collection<WindowSummary> testWindows) {
        this.setTestWindows(testWindows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithmArn() != null) {
            sb.append("AlgorithmArn: ").append(this.getAlgorithmArn()).append(",");
        }
        if (this.getTestWindows() != null) {
            sb.append("TestWindows: ").append(this.getTestWindows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        if (other.getAlgorithmArn() == null ^ this.getAlgorithmArn() == null) {
            return false;
        }
        if (other.getAlgorithmArn() != null && !other.getAlgorithmArn().equals(this.getAlgorithmArn())) {
            return false;
        }
        if (other.getTestWindows() == null ^ this.getTestWindows() == null) {
            return false;
        }
        return other.getTestWindows() == null || other.getTestWindows().equals(this.getTestWindows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithmArn() == null ? 0 : this.getAlgorithmArn().hashCode());
        hashCode = 31 * hashCode + (this.getTestWindows() == null ? 0 : this.getTestWindows().hashCode());
        return hashCode;
    }

    public EvaluationResult clone() {
        try {
            return (EvaluationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

