/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.docdb.AmazonDocDB;
import com.amazonaws.services.docdb.model.DescribeDBInstancesRequest;
import com.amazonaws.services.docdb.model.DescribeDBInstancesResult;
import com.amazonaws.services.docdb.waiters.DBInstanceAvailable;
import com.amazonaws.services.docdb.waiters.DBInstanceDeleted;
import com.amazonaws.services.docdb.waiters.DescribeDBInstancesFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonDocDBWaiters {
    private final AmazonDocDB client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonDocDBWaiters");

    @SdkInternalApi
    public AmazonDocDBWaiters(AmazonDocDB client) {
        this.client = client;
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceAvailable() {
        return new WaiterBuilder<DescribeDBInstancesRequest, DescribeDBInstancesResult>().withSdkFunction(new DescribeDBInstancesFunction(this.client)).withAcceptors(new DBInstanceAvailable.IsAvailableMatcher(), new DBInstanceAvailable.IsDeletedMatcher(), new DBInstanceAvailable.IsDeletingMatcher(), new DBInstanceAvailable.IsFailedMatcher(), new DBInstanceAvailable.IsIncompatiblerestoreMatcher(), new DBInstanceAvailable.IsIncompatibleparametersMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceDeleted() {
        return new WaiterBuilder<DescribeDBInstancesRequest, DescribeDBInstancesResult>().withSdkFunction(new DescribeDBInstancesFunction(this.client)).withAcceptors(new DBInstanceDeleted.IsDeletedMatcher(), new DBInstanceDeleted.IsDBInstanceNotFoundMatcher(), new DBInstanceDeleted.IsCreatingMatcher(), new DBInstanceDeleted.IsModifyingMatcher(), new DBInstanceDeleted.IsRebootingMatcher(), new DBInstanceDeleted.IsResettingmastercredentialsMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

