/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.services.docdb.model.DBEngineVersion;
import com.amazonaws.services.docdb.model.UpgradeTarget;
import com.amazonaws.services.docdb.model.transform.UpgradeTargetStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DBEngineVersionStaxUnmarshaller
implements Unmarshaller<DBEngineVersion, StaxUnmarshallerContext> {
    private static DBEngineVersionStaxUnmarshaller instance;

    @Override
    public DBEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBEngineVersion dBEngineVersion = new DBEngineVersion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBEngineVersion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    dBEngineVersion.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dBEngineVersion.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    dBEngineVersion.setDBParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBEngineVersionDescription", targetDepth)) {
                    dBEngineVersion.setDBEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget", targetDepth)) {
                    dBEngineVersion.withValidUpgradeTarget(new ArrayList<UpgradeTarget>());
                    continue;
                }
                if (context.testExpression("ValidUpgradeTarget/UpgradeTarget", targetDepth)) {
                    dBEngineVersion.withValidUpgradeTarget(UpgradeTargetStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExportableLogTypes", targetDepth)) {
                    dBEngineVersion.withExportableLogTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ExportableLogTypes/member", targetDepth)) {
                    dBEngineVersion.withExportableLogTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SupportsLogExportsToCloudwatchLogs", targetDepth)) continue;
                dBEngineVersion.setSupportsLogExportsToCloudwatchLogs(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBEngineVersion;
    }

    public static DBEngineVersionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBEngineVersionStaxUnmarshaller();
        }
        return instance;
    }
}

