/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.CopyDBClusterParameterGroupRequest;
import com.amazonaws.services.docdb.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CopyDBClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBClusterParameterGroupRequest>, CopyDBClusterParameterGroupRequest> {
    @Override
    public Request<CopyDBClusterParameterGroupRequest> marshall(CopyDBClusterParameterGroupRequest copyDBClusterParameterGroupRequest) {
        if (copyDBClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyDBClusterParameterGroupRequest> request = new DefaultRequest<CopyDBClusterParameterGroupRequest>(copyDBClusterParameterGroupRequest, "AmazonDocDB");
        request.addParameter("Action", "CopyDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBClusterParameterGroupRequest.getSourceDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBClusterParameterGroupIdentifier", StringUtils.fromString(copyDBClusterParameterGroupRequest.getSourceDBClusterParameterGroupIdentifier()));
        }
        if (copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBClusterParameterGroupIdentifier", StringUtils.fromString(copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupIdentifier()));
        }
        if (copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupDescription() != null) {
            request.addParameter("TargetDBClusterParameterGroupDescription", StringUtils.fromString(copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupDescription()));
        }
        if (copyDBClusterParameterGroupRequest.getTags() != null) {
            List<Tag> tagsList = copyDBClusterParameterGroupRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

